/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyProviderBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.Tier;
import owmii.powah.block.magmator.MagmatorTile;
import owmii.powah.config.Configs;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.MagmatorContainer;

public class MagmatorBlock
extends AbstractEnergyProviderBlock<Tier>
implements IWaterLoggable {
    public MagmatorBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setDefaultState();
    }

    public IEnergyProviderConfig<Tier> getEnergyConfig() {
        return Configs.MAGMATOR;
    }

    public int stackSize() {
        return 1;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagmatorTile((Tier)this.variant);
    }

    protected boolean semiFullShape() {
        return true;
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof MagmatorTile) {
            return new MagmatorContainer(IContainers.MAGMATOR, id, playerInventory, (MagmatorTile)te);
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof MagmatorTile) {
            MagmatorTile magmator = (MagmatorTile)tile;
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)magmator.tank)) {
                magmator.markDirtyAndSync();
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    protected boolean hasLitProp() {
        return true;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.HORIZONTAL;
    }

    protected boolean isPlacerFacing() {
        return true;
    }
}

