/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energyhopper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;
import owmii.powah.block.Tier;
import owmii.powah.block.energyhopper.EnergyHopperTile;
import owmii.powah.config.Configs;
import owmii.powah.config.EnergyHopperConfig;
import owmii.powah.inventory.EnergyHopperContainer;
import owmii.powah.inventory.IContainers;

public class EnergyHopperBlock
extends AbstractEnergyBlock<Tier> {
    public static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public EnergyHopperBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setDefaultState();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.ENERGY_HOPPER;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergyHopperTile((Tier)this.variant);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        TileEntity tile = worldIn.func_175625_s(pos.func_177972_a(direction));
        return (tile instanceof IInventory || tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).isPresent()) && !Energy.isPresent((TileEntity)tile, (Direction)direction);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof EnergyHopperTile) {
            return new EnergyHopperContainer(IContainers.ENERGY_HOPPER, id, playerInventory, (EnergyHopperTile)te);
        }
        return null;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent("info.powah.charging.speed", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)this.getChargingSpeed())}).func_211708_a(TextFormatting.GRAY));
    }

    public long getChargingSpeed() {
        return ((EnergyHopperConfig)this.getEnergyConfig()).getChargingSpeed((Tier)this.variant);
    }

    static {
        SHAPES.put(Direction.UP, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        SHAPES.put(Direction.DOWN, EnergyHopperBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        SHAPES.put(Direction.NORTH, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0));
        SHAPES.put(Direction.SOUTH, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0));
        SHAPES.put(Direction.EAST, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
        SHAPES.put(Direction.WEST, EnergyHopperBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }
}

