/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.tileentity.FluidHandlerBlock;

public class TileFlopper
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private int transferCooldown = -1;
    private Tank tank = new SingleUseTank(BlockFlopperConfig.capacityMb){

        protected void sendUpdate() {
            super.sendUpdate();
            TileFlopper.this.sendUpdate();
        }
    };

    public TileFlopper() {
        super(RegistryEntries.TILE_ENTITY_FLOPPER);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(this::getTank));
    }

    public Tank getTank() {
        return this.tank;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT tagTank = new CompoundNBT();
        this.tank.writeToNBT(tagTank);
        tag.func_218657_a("tank", (INBT)tagTank);
        return super.func_189515_b(tag);
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    protected boolean updateHopper() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown() && ((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()), (IProperty)BlockFlopper.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                boolean worked = false;
                boolean workedWorld = false;
                if (!this.tank.isEmpty()) {
                    boolean bl = BlockFlopperConfig.pushFluidRate > 0 && this.pushFluidsToTank() || (workedWorld = BlockFlopperConfig.pushFluidsWorld && this.pushFluidsToWorld()) ? true : (worked = false);
                }
                if (!this.tank.isFull()) {
                    boolean bl = BlockFlopperConfig.pullFluidRate > 0 && this.pullFluidsFromTank() || (workedWorld = BlockFlopperConfig.pullFluidsWorld && this.pullFluidsFromWorld() || workedWorld) || worked ? true : (worked = false);
                }
                if (worked) {
                    this.setTransferCooldown(workedWorld ? BlockFlopperConfig.workWorldCooldown : BlockFlopperConfig.workCooldown);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected Direction getFacing() {
        return (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockFlopper.FACING);
    }

    protected boolean pushFluidsToTank() {
        Direction targetSide = this.getFacing().func_176734_d();
        BlockPos targetPos = this.func_174877_v().func_177972_a(this.getFacing());
        return (Boolean)TileHelpers.getCapability((IBlockReader)this.field_145850_b, (BlockPos)targetPos, (Direction)targetSide, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)BlockFlopperConfig.pushFluidRate, (boolean)true).isEmpty()).orElse((Object)false);
    }

    protected boolean pullFluidsFromTank() {
        BlockPos targetPos = this.func_174877_v().func_177972_a(Direction.UP);
        return (Boolean)TileHelpers.getCapability((IBlockReader)this.field_145850_b, (BlockPos)targetPos, (Direction)Direction.DOWN, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)BlockFlopperConfig.pullFluidRate, (boolean)true).isEmpty()).orElse((Object)false);
    }

    protected boolean pushFluidsToWorld() {
        BlockPos targetPos = this.func_174877_v().func_177972_a(this.getFacing());
        BlockState destBlockState = this.field_145850_b.func_180495_p(targetPos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_185904_a().func_76222_j();
        if (this.field_145850_b.func_175623_d(targetPos) || isDestNonSolid && isDestReplaceable && !destMaterial.func_76224_d()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (!this.field_145850_b.field_73011_w.func_177500_n() || !fluidStack.getFluid().getAttributes().doesVaporize((ILightReader)this.field_145850_b, this.field_174879_c, fluidStack)) {
                return this.getFluidBlockHandler(fluidStack.getFluid(), this.field_145850_b, targetPos).map(fluidHandler -> {
                    FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)Integer.MAX_VALUE, (boolean)true);
                    if (!moved.isEmpty()) {
                        if (BlockFlopperConfig.worldPullPushSounds) {
                            SoundEvent soundevent = moved.getFluid().getAttributes().getFillSound(moved);
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                            this.field_145850_b.func_190524_a(this.field_174879_c, Blocks.field_150350_a, this.field_174879_c);
                        }
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        return false;
    }

    private Optional<IFluidHandler> getFluidBlockHandler(Fluid fluid, World world, BlockPos targetPos) {
        if (!fluid.getAttributes().canBePlacedInWorld((ILightReader)world, targetPos, fluid.func_207188_f())) {
            return Optional.empty();
        }
        BlockState state = fluid.getAttributes().getBlock((ILightReader)world, targetPos, fluid.func_207188_f());
        return Optional.of(new BlockWrapper(state, world, targetPos));
    }

    protected boolean pullFluidsFromWorld() {
        BlockPos targetPos = this.func_174877_v().func_177972_a(Direction.UP);
        BlockState destBlockState = this.field_145850_b.func_180495_p(targetPos);
        return (Boolean)this.wrapFluidBlock(destBlockState, this.field_145850_b, targetPos).map(fluidHandler -> {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
            if (!moved.isEmpty()) {
                if (BlockFlopperConfig.worldPullPushSounds) {
                    SoundEvent soundevent = moved.getFluid().getAttributes().getEmptySound(moved);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                    this.field_145850_b.func_190524_a(this.field_174879_c, Blocks.field_150350_a, this.field_174879_c);
                }
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    private LazyOptional<IFluidHandler> wrapFluidBlock(BlockState blockState, World world, BlockPos targetPos) {
        if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
            return LazyOptional.of(() -> new FluidHandlerBlock(blockState, world, targetPos));
        }
        return LazyOptional.empty();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

