/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mcjty.incontrol.InControl;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PotentialSpawnRule;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SummonAidRule;
import org.apache.logging.log4j.Level;

public class RulesManager {
    public static List<SpawnRule> rules = new ArrayList<SpawnRule>();
    public static List<SummonAidRule> summonAidRules = new ArrayList<SummonAidRule>();
    public static List<PotentialSpawnRule> potentialSpawnRules = new ArrayList<PotentialSpawnRule>();
    public static List<LootRule> lootRules = new ArrayList<LootRule>();
    public static List<ExperienceRule> experienceRules = new ArrayList<ExperienceRule>();
    private static String path;

    public static void reloadRules() {
        rules.clear();
        summonAidRules.clear();
        potentialSpawnRules.clear();
        lootRules.clear();
        experienceRules.clear();
        RulesManager.readAllRules();
    }

    public static void setRulePath(Path path) {
        RulesManager.path = path.toString();
    }

    public static void readRules() {
        RulesManager.readAllRules();
    }

    private static boolean exists(String file) {
        File f = new File(file);
        return f.exists() && !f.isDirectory();
    }

    public static boolean readCustomSpawn(String file) {
        System.out.println("file = " + file);
        if (!RulesManager.exists(file)) {
            return false;
        }
        rules.clear();
        RulesManager.readRules(null, file, SpawnRule::parse, rules);
        return true;
    }

    public static boolean readCustomSummonAid(String file) {
        if (!RulesManager.exists(file)) {
            return false;
        }
        summonAidRules.clear();
        RulesManager.readRules(null, file, SummonAidRule::parse, summonAidRules);
        return true;
    }

    public static boolean readCustomPotentialSpawn(String file) {
        if (!RulesManager.exists(file)) {
            return false;
        }
        potentialSpawnRules.clear();
        RulesManager.readRules(null, file, PotentialSpawnRule::parse, potentialSpawnRules);
        return true;
    }

    public static boolean readCustomLoot(String file) {
        if (!RulesManager.exists(file)) {
            return false;
        }
        lootRules.clear();
        RulesManager.readRules(null, file, LootRule::parse, lootRules);
        return true;
    }

    private static void readAllRules() {
        File directory = new File(path + File.separator + "incontrol");
        if (!directory.exists()) {
            directory.mkdir();
        }
        RulesManager.readRules(path, "spawn.json", SpawnRule::parse, rules);
        RulesManager.readRules(path, "summonaid.json", SummonAidRule::parse, summonAidRules);
        RulesManager.readRules(path, "potentialspawn.json", PotentialSpawnRule::parse, potentialSpawnRules);
        RulesManager.readRules(path, "loot.json", LootRule::parse, lootRules);
        RulesManager.readRules(path, "experience.json", ExperienceRule::parse, experienceRules);
    }

    private static <T> void readRules(String path, String filename, Function<JsonElement, T> parser, List<T> rules) {
        JsonElement element = RulesManager.getRootElement(path, filename);
        if (element == null) {
            return;
        }
        int i = 0;
        for (JsonElement entry : element.getAsJsonArray()) {
            T rule = parser.apply(entry);
            if (rule != null) {
                rules.add(rule);
            } else {
                InControl.setup.getLogger().log(Level.ERROR, "Rule " + i + " in " + filename + " is invalid, skipping!");
            }
            ++i;
        }
    }

    private static JsonElement getRootElement(String path, String filename) {
        BufferedReader br;
        File file = path == null ? new File(filename) : new File(path + File.separator + "incontrol", filename);
        if (!file.exists()) {
            RulesManager.makeEmptyRuleFile(file);
            return null;
        }
        InControl.setup.getLogger().log(Level.INFO, "Reading spawn rules from " + filename);
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            InControl.setup.getLogger().log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            InControl.setup.getLogger().log(Level.ERROR, "Error reading " + filename + "!");
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        return element;
    }

    private static void makeEmptyRuleFile(File file) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            InControl.setup.getLogger().log(Level.ERROR, "Error writing " + file.getName() + "!");
            return;
        }
        JsonArray array = new JsonArray();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
        writer.close();
    }
}

