/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import com.github.commoble.potionofbees.ResourceLocations;
import com.github.commoble.potionofbees.SplashPotionOfBeesEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.HoneycombLarvaBlock;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.modcompatibility.PotionOfBeesBeePotionDispenseBehavior;
import org.apache.logging.log4j.Level;

public class PotionOfBeesCompat {
    private static final DefaultDispenseItemBehavior BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM = new PotionOfBeesBeePotionDispenseBehavior();

    public static void setupPotionOfBees() {
        ModChecking.potionOfBeesPresent = true;
        if (ForgeRegistries.ITEMS.containsKey(ResourceLocations.POTION_OF_BEES)) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocations.POTION_OF_BEES)), (IDispenseItemBehavior)BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM);
        } else {
            Bumblezone.LOGGER.log(Level.WARN, "Error trying to change the dispenser behavior for Potion of Bee's bee potion item. Please report this issue to Bumblezone author.");
        }
        if (ForgeRegistries.ITEMS.containsKey(ResourceLocations.SPLASH_POTION_OF_BEES)) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocations.SPLASH_POTION_OF_BEES)), (IDispenseItemBehavior)BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM);
        } else {
            Bumblezone.LOGGER.log(Level.WARN, "Error trying to change the dispenser behavior for Potion of Bee's bee splash potion item. Please report this issue to Bumblezone author.");
        }
    }

    public static void POBReviveLarvaBlockEvent(ProjectileImpactEvent.Throwable event) {
        Entity thrownEntity = event.getEntity();
        if (thrownEntity instanceof SplashPotionOfBeesEntity) {
            World world = thrownEntity.field_70170_p;
            Vec3d hitBlockPos = event.getRayTraceResult().func_216347_e();
            BlockPos originalPosition = new BlockPos(hitBlockPos);
            BlockPos.Mutable position = new BlockPos.Mutable(originalPosition);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        position.func_189533_g((Vec3i)originalPosition).func_196234_d(x, y, z);
                        BlockState block = world.func_180495_p((BlockPos)position);
                        if (block.func_177230_c() != BzBlocks.DEAD_HONEYCOMB_LARVA.get()) continue;
                        PotionOfBeesCompat.reviveLarvaBlock(world, block, (BlockPos)position);
                    }
                }
            }
        }
    }

    private static void reviveLarvaBlock(World world, BlockState state, BlockPos position) {
        world.func_175656_a(position, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_LARVA.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, state.func_177229_b((IProperty)BlockStateProperties.field_208155_H))).func_206870_a((IProperty)HoneycombLarvaBlock.STAGE, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(3))));
    }
}

