/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import java.util.concurrent.Callable;
import net.minecraftforge.fml.ModList;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.modcompatibility.BeesourcefulCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.PotionOfBeesCompat;
import org.apache.logging.log4j.Level;

public class ModChecking {
    public static boolean buzzierBeesPresent = false;
    public static boolean potionOfBeesPresent = false;
    public static boolean beesourcefulPresent = false;

    public static void setupModCompat() {
        try {
            ModChecking.runIfModIsLoaded("buzzierbees", () -> () -> BuzzierBeesCompat.setupBuzzierBees());
        }
        catch (Exception e) {
            Bumblezone.LOGGER.log(Level.INFO, "ERROR: Somehow tried calling buzzierbees code when it isn't on.");
            e.printStackTrace();
        }
        try {
            ModChecking.runIfModIsLoaded("potionofbees", () -> () -> PotionOfBeesCompat.setupPotionOfBees());
        }
        catch (Exception e) {
            Bumblezone.LOGGER.log(Level.INFO, "ERROR: Somehow tried calling potionofbees code when it isn't on.");
            e.printStackTrace();
        }
        try {
            ModChecking.runIfModIsLoaded("beesourceful", () -> () -> BeesourcefulCompat.setupBeesourceful());
        }
        catch (Exception e) {
            Bumblezone.LOGGER.log(Level.INFO, "ERROR: Somehow tried calling beesourceful code when it isn't on.");
            e.printStackTrace();
        }
    }

    public static void runIfModIsLoaded(String modid, Callable<Runnable> toRun) throws Exception {
        if (ModList.get().isLoaded(modid)) {
            toRun.call().run();
        }
    }
}

