/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.bagel.buzzierbees.core.registry.BBEntities;
import com.bagel.buzzierbees.core.registry.BBItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.generation.BzChunkGenerator;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeeBottledBeeDispenseBehavior;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;

public class BuzzierBeesCompat {
    private static final DefaultDispenseItemBehavior BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM = new BuzzierBeeBottledBeeDispenseBehavior();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState FILLED_POROUS_HONEYCOMB = ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState POROUS_HONEYCOMB = ((Block)BzBlocks.POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();
    private static final BlockState WAX_BLOCK = ((Block)BBBlocks.WAX_BLOCK.get()).func_176223_P();
    private static final BlockState CRYSTALLIZED_HONEY_BLOCK = ((Block)BBBlocks.CRYSTALLIZED_HONEY_BLOCK.get()).func_176223_P();
    private static final BlockState HIVE_PLANKS = ((Block)BBBlocks.HIVE_PLANKS.get()).func_176223_P();

    public static void setupBuzzierBees() {
        ModChecking.buzzierBeesPresent = true;
        if (Bumblezone.BzConfig.spawnHoneySlimeMob.get().booleanValue()) {
            BzChunkGenerator.MOBS_SLIME_ENTRY = new Biome.SpawnListEntry((EntityType)BBEntities.HONEY_SLIME.get(), 1, 1, 1);
        }
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_BEE.get()), (IDispenseItemBehavior)BEHAVIOUR_BOTTLED_BEE_DISPENSE_ITEM);
    }

    public static void BBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        MobEntity entity = (MobEntity)event.getEntity();
        IWorld world = event.getWorld();
        if (entity.func_200600_R() == EntityType.field_226289_e_) {
            MobEntity slimeentity = (MobEntity)((EntityType)BBEntities.HONEY_SLIME.get()).func_200721_a(entity.field_70170_p);
            BlockPos.Mutable blockpos = new BlockPos.Mutable(entity.func_180425_c());
            while (world.func_180495_p((BlockPos)blockpos).func_196958_f()) {
                blockpos.func_189536_c(Direction.DOWN);
            }
            blockpos.func_189534_c(Direction.UP, 2);
            slimeentity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
            ILivingEntityData ilivingentitydata = null;
            ilivingentitydata = slimeentity.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)slimeentity)), event.getSpawnReason(), ilivingentitydata, (CompoundNBT)null);
            world.func_217376_c((Entity)slimeentity);
        }
    }

    public static void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int xpos = x & 0xF;
        int zpos = z & 0xF;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        boolean topMostBlock = false;
        for (int ypos = 255; ypos >= 0; --ypos) {
            blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
            BlockState currentBlockState = chunk.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlockState.func_177230_c() == null) continue;
            if (currentBlockState.func_185904_a() == Material.field_151579_a || currentBlockState.func_185904_a() == Material.field_151586_h) {
                topMostBlock = true;
                continue;
            }
            if (currentBlockState == STONE) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable, HONEYCOMB_BLOCK, false);
            } else if (currentBlockState == POROUS_HONEYCOMB) {
                if (topMostBlock) {
                    if ((double)ypos <= (double)(seaLevel + 2) + Math.max(noise, 0.0) + (double)random.nextInt(2)) {
                        if (Bumblezone.BzConfig.waxBlocksWorldgen.get().booleanValue()) {
                            chunk.func_177436_a((BlockPos)blockpos$Mutable, WAX_BLOCK, false);
                        } else {
                            chunk.func_177436_a((BlockPos)blockpos$Mutable, FILLED_POROUS_HONEYCOMB, false);
                        }
                    }
                } else if (!topMostBlock) {
                    if ((double)ypos > (double)(seaLevel + 2) + Math.max(noise, 0.0) + (double)random.nextInt(2)) {
                        if (Bumblezone.BzConfig.crystallizedHoneyWorldgen.get().booleanValue()) {
                            chunk.func_177436_a((BlockPos)blockpos$Mutable, CRYSTALLIZED_HONEY_BLOCK, false);
                        } else {
                            chunk.func_177436_a((BlockPos)blockpos$Mutable, POROUS_HONEYCOMB, false);
                        }
                    } else {
                        chunk.func_177436_a((BlockPos)blockpos$Mutable, FILLED_POROUS_HONEYCOMB, false);
                    }
                } else if ((double)ypos <= (double)(seaLevel + 2) + Math.max(noise, 0.0) + (double)random.nextInt(2)) {
                    chunk.func_177436_a((BlockPos)blockpos$Mutable, FILLED_POROUS_HONEYCOMB, false);
                }
            } else if (currentBlockState.func_185904_a() == Material.field_151579_a && ypos < seaLevel) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable, defaultFluid, false);
            }
            topMostBlock = false;
        }
    }

    public static void makeBedrock(IChunk chunk, Random random) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int xStart = chunk.func_76632_l().func_180334_c();
        int zStart = chunk.func_76632_l().func_180333_d();
        int roofHeight = 253;
        int floorHeight = 2;
        for (BlockPos blockpos : BlockPos.func_191531_b((int)xStart, (int)0, (int)zStart, (int)(xStart + 15), (int)0, (int)(zStart + 15))) {
            for (int ceilingY = 255; ceilingY >= roofHeight - 7 - random.nextInt(2); --ceilingY) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), ceilingY, blockpos.func_177952_p()), HIVE_PLANKS, false);
            }
            for (int floorY = 0; floorY <= floorHeight + random.nextInt(2); ++floorY) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), floorY, blockpos.func_177952_p()), HIVE_PLANKS, false);
            }
        }
    }

    public static ActionResultType honeyWandTakingHoney(ItemStack itemstack, BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand) {
        if (itemstack.func_77973_b() == BBItems.HONEY_WAND.get() && !playerEntity.func_213453_ef()) {
            if (!playerEntity.func_184812_l_()) {
                playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)BBItems.STICKY_HONEY_WAND.get()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static ActionResultType honeyWandGivingHoney(ItemStack itemstack, BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand) {
        if (itemstack.func_77973_b() == BBItems.STICKY_HONEY_WAND.get() && !playerEntity.func_213453_ef()) {
            if (!playerEntity.func_184812_l_()) {
                playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)BBItems.HONEY_WAND.get()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static ActionResultType bottledBeeInteract(ItemStack itemstack, BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand) {
        if (itemstack.func_77973_b() == BBItems.BOTTLE_OF_BEE.get() && !playerEntity.func_213453_ef()) {
            if (!playerEntity.func_184812_l_()) {
                playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_151069_bo));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }
}

