/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.generation;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.features.placement.BzPlacingUtils;
import net.telepathicgrunt.bumblezone.generation.BzNoiseChunkGenerator;

public class BzChunkGenerator
extends BzNoiseChunkGenerator<OverworldGenSettings> {
    private static final float[] field_222576_h = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_222575_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator depthNoise;
    public static Biome.SpawnListEntry MOBS_SLIME_ENTRY = new Biome.SpawnListEntry(EntityType.field_200743_ai, 1, 1, 1);
    public static Biome.SpawnListEntry MOBS_BEE_ENTRY = new Biome.SpawnListEntry(EntityType.field_226289_e_, 1, 4, 4);

    public BzChunkGenerator(IWorld world, BiomeProvider provider, OverworldGenSettings settingsIn) {
        super(world, provider, 4, 8, 256, settingsIn);
        this.randomSeed.func_202423_a(2620);
        this.depthNoise = new OctavesNoiseGenerator(this.randomSeed, 15, 0);
    }

    public void func_202093_c(WorldGenRegion region) {
        int xChunk = region.func_201679_a();
        int zChunk = region.func_201680_b();
        int xCord = xChunk << 4;
        int zCord = zChunk << 4;
        Biome biome = region.func_226691_t_(new ChunkPos(xChunk, zChunk).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), xCord, zCord);
        while (sharedseedrandom.nextFloat() < biome.func_76741_f()) {
            MobEntity mobentity;
            Entity entity;
            boolean isSlime = sharedseedrandom.nextFloat() < 0.25f;
            Biome.SpawnListEntry biome$spawnlistentry = isSlime ? MOBS_SLIME_ENTRY : MOBS_BEE_ENTRY;
            ILivingEntityData ilivingentitydata = null;
            int startingX = xCord + sharedseedrandom.nextInt(16);
            int startingZ = zCord + sharedseedrandom.nextInt(16);
            int currentX = startingX;
            int currentZ = startingZ;
            BlockPos.Mutable blockpos = new BlockPos.Mutable(currentX, 0, currentZ);
            int height = BzPlacingUtils.topOfSurfaceBelowHeight((IWorld)region, sharedseedrandom.nextInt(255), -1, (BlockPos)blockpos) + 1;
            if (!biome$spawnlistentry.field_200702_b.func_200720_b() || height <= 0 || height >= 255) continue;
            float width = biome$spawnlistentry.field_200702_b.func_220333_h();
            double xLength = MathHelper.func_151237_a((double)startingX, (double)((double)xCord + (double)width), (double)((double)xCord + 16.0 - (double)width));
            double zLength = MathHelper.func_151237_a((double)startingZ, (double)((double)zCord + (double)width), (double)((double)zCord + 16.0 - (double)width));
            try {
                entity = biome$spawnlistentry.field_200702_b.func_200721_a((World)region.func_201672_e());
            }
            catch (Exception exception) {
                Bumblezone.LOGGER.warn("Failed to create mob", (Throwable)exception);
                continue;
            }
            entity.func_70012_b(xLength, (double)height, zLength, sharedseedrandom.nextFloat() * 360.0f, 0.0f);
            if (!(entity instanceof MobEntity) || ForgeHooks.canEntitySpawn((MobEntity)(mobentity = (MobEntity)entity), (IWorld)region, (double)xLength, (double)height, (double)zLength, null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1 || !mobentity.func_213380_a((IWorld)region, SpawnReason.CHUNK_GENERATION) || !mobentity.func_205019_a((IWorldReader)region)) continue;
            if (mobentity instanceof BeeEntity && this.randomSeed.nextFloat() < 0.2f) {
                ((BeeEntity)entity).func_226404_d_(8, true);
            }
            ilivingentitydata = mobentity.func_213386_a((IWorld)region, region.func_175649_E(new BlockPos((Entity)mobentity)), SpawnReason.CHUNK_GENERATION, ilivingentitydata, (CompoundNBT)null);
            region.func_217376_c((Entity)mobentity);
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        return super.func_177458_a(creatureType, pos);
    }

    @Override
    protected void fillNoiseColumn(double[] areaArrayIn, int x, int z) {
        this.setupPerlinNoiseGenerators(areaArrayIn, x, z, 2600.0, 250.0, 600.0, 8.0, 4.0, 3.0, -10, -10);
    }

    @Override
    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        double d1 = ((double)p_222545_5_ - (8.5 + p_222545_1_ * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / p_222545_3_;
        if (d1 < 0.0) {
            d1 *= 2.0;
        }
        return d1;
    }

    @Override
    protected double[] getBiomeNoiseColumn(int x, int z) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int y = this.func_222530_f();
        float f3 = this.field_222542_c.func_225526_b_(x, y, z).func_185355_j();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                Biome biome = this.field_222542_c.func_225526_b_(x + j, y, z + k);
                float depthWeight = biome.func_185355_j();
                float scaleWeight = biome.func_185360_m();
                depthWeight = 1.0f + depthWeight * 1.1f;
                scaleWeight = 1.0f + scaleWeight * 10.0f;
                float f6 = field_222576_h[j + 2 + (k + 2) * 5] / (depthWeight + 5.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += scaleWeight * f6;
                f1 += depthWeight * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getNoiseDepthAt(x, z);
        adouble[1] = f;
        return adouble;
    }

    private double getNoiseDepthAt(int x, int z) {
        double noise = this.depthNoise.func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (noise < 0.0) {
            noise = -noise * 0.3;
        }
        if ((noise = noise * 3.0 - 2.0) < 0.0) {
            noise /= 28.0;
        } else {
            if (noise > 1.0) {
                noise = 1.0;
            }
            noise /= 40.0;
        }
        return noise;
    }

    public void func_203222_a(ServerWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public int func_205470_d() {
        return this.func_222530_f() + 1;
    }
}

