/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandBack {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"back").requires(source -> source.func_197034_c(0))).executes(context -> CommandBack.back((CommandSource)context.getSource())));
    }

    private static int back(CommandSource source) throws CommandSyntaxException {
        boolean recentlyDied;
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Location location = eslPlayer.getData().getLastLocation();
        if (location == null) {
            player.func_145747_a((ITextComponent)Methods.formatText("back.maessentials.not_found", new Object[0]));
            return 1;
        }
        long deathTime = eslPlayer.getData().getLastDeath();
        boolean bl = recentlyDied = deathTime + (long)ConfigValues.back_death_custom_cooldown.intValue() > Methods.currentTimestamp();
        if (ConfigValues.back_death_custom_cooldown != 0 && recentlyDied) {
            long cooldown = eslPlayer.getUsage().getTeleportCooldown("back", ConfigValues.back_death_custom_cooldown.intValue());
            if (cooldown != 0L) {
                player.func_145747_a((ITextComponent)Methods.formatText("back.maessentials.cooldown.teleport", cooldown));
                return 1;
            }
        } else {
            long cooldown = eslPlayer.getUsage().getTeleportCooldown("back", ConfigValues.back_cooldown.intValue());
            if (cooldown != 0L) {
                player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown.teleport", cooldown));
                return 1;
            }
        }
        eslPlayer.getUsage().setCommandUsage("back");
        eslPlayer.saveData();
        if (Methods.simpleTeleport(player, location, "back", ConfigValues.back_delay.intValue())) {
            if (ConfigValues.back_delay == 0) {
                player.func_145747_a((ITextComponent)Methods.formatText("back.maessentials.success", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("back.maessentials.success.wait", ConfigValues.back_delay));
            }
        }
        return 1;
    }
}

