function initializeCoreMod() {
    Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/client/renderer/ItemRenderer',
		'methodName' : resolveName('func_229111_a_'), // renderItem
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;IILnet/minecraft/client/renderer/model/IBakedModel;)V'
	}
	
	var handler = {
		'class': 'com/endertech/minecraft/forge/events/ItemRenderEvent',
		'methodName': 'onRenderItem',
		'methodDesc': '(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;IILnet/minecraft/client/renderer/model/IBakedModel;)V'
	}

	var node = {
		'class': target.class,
		'methodName': resolveName('func_229114_a_'), // "renderModel"
		'methodDesc': '(Lnet/minecraft/client/renderer/model/IBakedModel;Lnet/minecraft/item/ItemStack;IILcom/mojang/blaze3d/matrix/MatrixStack;Lcom/mojang/blaze3d/vertex/IVertexBuilder;)V'
	}
	
    var instructions = [
		insnLoadObj(1, "itemStack"),
		insnLoadObj(2, "transformType"),
		insnLoadInt(3, "leftHand"),
		insnLoadObj(4, "matrixStack"),
		insnLoadObj(5, "buffer"),
		insnLoadInt(6, "combinedLight"),
		insnLoadInt(7, "combinedOverlay"),
		insnLoadObj(8, "model"),
		insnCallHandler(handler)
	];
    
	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions);
				return method;
			}
		}
	}
}