/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.comforts.common.block.ComfortsBaseBlock;
import top.theillusivec4.comforts.common.block.HammockBlock;

public class RopeAndNailBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty SUPPORTING = BooleanProperty.func_177716_a((String)"supporting");
    private static final Map<Direction, VoxelShape> SHAPES_R = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0)));
    private static final Map<Direction, VoxelShape> SHAPES_S = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)6.0, (double)3.0, (double)9.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)8.0, (double)7.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)9.0, (double)3.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)6.0, (double)7.0, (double)8.0, (double)10.0)));

    public RopeAndNailBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185852_e).func_200943_b(0.2f));
        this.setRegistryName("comforts", "rope_and_nail");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)SUPPORTING) != false ? SHAPES_S.get(state.func_177229_b((IProperty)HORIZONTAL_FACING)) : SHAPES_R.get(state.func_177229_b((IProperty)HORIZONTAL_FACING));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        boolean valid = blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction);
        if (!valid && worldIn instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)worldIn;
            BlockPos frontPos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING));
            BlockState frontState = worldIn.func_180495_p(frontPos);
            if (((Boolean)state.func_177229_b((IProperty)SUPPORTING)).booleanValue() && frontState.func_177230_c() instanceof HammockBlock) {
                BedPart bedpart = (BedPart)frontState.func_177229_b((IProperty)BedBlock.field_176472_a);
                boolean isHead = bedpart == BedPart.HEAD;
                Direction frontDirection = (Direction)frontState.func_177229_b((IProperty)HORIZONTAL_FACING);
                BlockPos otherPos = frontPos.func_177972_a(HammockBlock.getDirectionToOther(bedpart, frontDirection));
                BlockState otherState = world.func_180495_p(otherPos);
                if (((Boolean)frontState.func_177229_b((IProperty)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
                    world.func_180501_a(frontPos, Blocks.field_150355_j.func_176223_P(), 35);
                } else {
                    world.func_180501_a(frontPos, Blocks.field_150350_a.func_176223_P(), 35);
                }
                if (otherState.func_177230_c() instanceof HammockBlock && otherState.func_177229_b((IProperty)BedBlock.field_176472_a) != bedpart) {
                    HammockBlock.finishHammockDrops(frontState, frontPos, otherState, otherPos, frontDirection, (World)world, null);
                    HammockBlock.dropRopeSupport(frontPos, frontDirection, isHead, (World)world);
                }
            }
        }
        return valid;
    }

    public void func_176208_a(World worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        BlockPos frontPos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING));
        BlockState frontState = worldIn.func_180495_p(frontPos);
        if (((Boolean)state.func_177229_b((IProperty)SUPPORTING)).booleanValue() && frontState.func_177230_c() instanceof HammockBlock) {
            BedPart bedpart = (BedPart)frontState.func_177229_b((IProperty)BedBlock.field_176472_a);
            boolean isHead = bedpart == BedPart.HEAD;
            Direction direction = (Direction)frontState.func_177229_b((IProperty)HORIZONTAL_FACING);
            BlockPos otherPos = frontPos.func_177972_a(HammockBlock.getDirectionToOther(bedpart, direction));
            BlockState otherState = worldIn.func_180495_p(otherPos);
            if (((Boolean)frontState.func_177229_b((IProperty)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
                worldIn.func_180501_a(frontPos, Blocks.field_150355_j.func_176223_P(), 35);
            } else {
                worldIn.func_180501_a(frontPos, Blocks.field_150350_a.func_176223_P(), 35);
            }
            worldIn.func_217378_a(player, 2001, frontPos, Block.func_196246_j((BlockState)frontState));
            if (otherState.func_177230_c() instanceof HammockBlock && otherState.func_177229_b((IProperty)BedBlock.field_176472_a) != bedpart) {
                HammockBlock.finishHammockDrops(frontState, frontPos, otherState, otherPos, direction, worldIn, player);
                HammockBlock.dropRopeSupport(frontPos, direction, isHead, worldIn);
                player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)frontState.func_177230_c()));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] directions;
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState blockstate = this.func_176223_P();
        World worldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : directions = context.func_196009_e()) {
            Direction direction1;
            if (!direction.func_176740_k().func_176722_c() || !(blockstate = (BlockState)((BlockState)blockstate.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)(direction1 = direction.func_176734_d()))).func_206870_a((IProperty)ComfortsBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a))).func_196955_c((IWorldReader)worldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176734_d() == stateIn.func_177229_b((IProperty)HORIZONTAL_FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    @Nonnull
    public BlockState func_185499_a(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SUPPORTING, HORIZONTAL_FACING, ComfortsBaseBlock.WATERLOGGED});
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ComfortsBaseBlock.WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

