/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;

public class ModDirTransformerDiscoverer
implements ITransformerDiscoveryService {
    private static List<Path> transformers = new ArrayList<Path>();
    private static List<Path> locators = new ArrayList<Path>();

    public List<Path> candidates(Path gameDirectory) {
        ModDirTransformerDiscoverer.scan(gameDirectory);
        return transformers;
    }

    public static List<Path> allExcluded() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.addAll(transformers);
        paths.addAll(locators);
        return paths;
    }

    public static List<Path> getExtraLocators() {
        return locators;
    }

    private static void scan(Path gameDirectory) {
        Path modsDir = gameDirectory.resolve(FMLPaths.MODSDIR.relative()).toAbsolutePath().normalize();
        transformers = new ArrayList<Path>();
        locators = new ArrayList<Path>();
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(modsDir, new FileAttribute[0]);
            Files.walk(modsDir, 1, new FileVisitOption[0]).forEach(ModDirTransformerDiscoverer::visitFile);
        }
        catch (IOException | IllegalStateException ioe) {
            LogManager.getLogger().error("Error during early discovery", (Throwable)ioe);
        }
    }

    private static void visitFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        if (!path.toString().endsWith(".jar")) {
            return;
        }
        if ((Long)LamdbaExceptionUtils.uncheck(() -> Files.size(path)) == 0L) {
            return;
        }
        try (ZipFile zf = new ZipFile(new File(path.toUri()));){
            if (zf.getEntry("META-INF/services/cpw.mods.modlauncher.api.ITransformationService") != null) {
                transformers.add(path);
            } else if (zf.getEntry("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator") != null) {
                locators.add(path);
            }
        }
        catch (IOException ioe) {
            LogManager.getLogger().error("Zip Error when loading jar file {}", (Object)path, (Object)ioe);
        }
    }
}

