/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.AdditiveMotionHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageAdditiveMotion;

public class PieceTrickAddMotion
extends PieceTrick {
    public static final double MULTIPLIER = 0.3;
    SpellParam<Entity> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> speed;

    public PieceTrickAddMotion(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam(this.direction);
        this.speed = new ParamNumber("psi.spellparam.speed", SpellParam.RED, false, true);
        this.addParam(this.speed);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double speedVal = (Double)this.getParamEvaluation(this.speed);
        if (speedVal == null) {
            speedVal = 1.0;
        }
        double absSpeed = Math.abs(speedVal);
        meta.addStat(EnumSpellStat.POTENCY, (int)this.multiplySafe(absSpeed, absSpeed, 3.5));
        meta.addStat(EnumSpellStat.COST, (int)this.multiplySafe(absSpeed, Math.max(1.0, absSpeed), 100.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        Vector3 directionVal = this.getParamValue(context, this.direction);
        double speedVal = this.getParamValue(context, this.speed).doubleValue();
        PieceTrickAddMotion.addMotion(context, targetVal, directionVal, speedVal);
        return null;
    }

    public static void addMotion(SpellContext context, Entity e, Vector3 dir, double speed) throws SpellRuntimeException {
        String keyv;
        context.verifyEntity(e);
        if (!context.isInRadius(e)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        dir = dir.copy().normalize().multiply(0.3 * speed);
        String key = "psi:Entity" + e.func_145782_y() + "Motion";
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (Math.abs(dir.x) > 1.0E-4 && !context.customData.containsKey(keyv = key + "X")) {
            x += dir.x;
            context.customData.put(keyv, 0);
        }
        if (Math.abs(dir.y) > 1.0E-4) {
            keyv = key + "Y";
            if (!context.customData.containsKey(keyv)) {
                y += dir.y;
                context.customData.put(keyv, 0);
            }
            if (e.func_213322_ci().func_82617_b() >= 0.0) {
                e.field_70143_R = 0.0f;
            }
        }
        if (Math.abs(dir.z) > 1.0E-4 && !context.customData.containsKey(keyv = key + "Z")) {
            z += dir.z;
            context.customData.put(keyv, 0);
        }
        if (e instanceof ServerPlayerEntity) {
            MessageAdditiveMotion motion = new MessageAdditiveMotion(e.func_145782_y(), x, y, z);
            MessageRegister.sendToPlayer(motion, (PlayerEntity)((ServerPlayerEntity)e));
        } else {
            AdditiveMotionHandler.addMotion(e, x, y, z);
        }
    }
}

