/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.vector;

import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorVectorRaycastAxis
extends PieceOperator {
    SpellParam<Vector3> origin;
    SpellParam<Vector3> ray;
    SpellParam<Number> max;

    public PieceOperatorVectorRaycastAxis(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", SpellParam.GREEN, false, false);
        this.addParam(this.ray);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.PURPLE, true, false);
        this.addParam(this.max);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 originVal = this.getParamValue(context, this.origin);
        Vector3 rayVal = this.getParamValue(context, this.ray);
        if (originVal == null || rayVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        double maxLen = 32.0;
        Number numberVal = this.getParamValue(context, this.max);
        if (numberVal != null) {
            maxLen = numberVal.doubleValue();
        }
        maxLen = Math.min(32.0, maxLen);
        Vector3 end = originVal.copy().add(rayVal.copy().normalize().multiply(maxLen));
        BlockRayTraceResult pos = context.caster.func_130014_f_().func_217299_a(new RayTraceContext(originVal.toVec3D(), end.toVec3D(), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)context.caster));
        if (pos.func_216346_c() == RayTraceResult.Type.MISS) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        Direction facing = pos.func_216354_b();
        return new Vector3(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
    }

    @Override
    public Class<?> getEvaluationType() {
        return Vector3.class;
    }
}

