/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChargepad
extends TileEntityMekanism {
    private static final Predicate<LivingEntity> CHARGE_PREDICATE = entity -> !entity.func_175149_v() && (entity instanceof PlayerEntity || entity instanceof EntityRobit);
    public Random random = new Random();
    private MachineEnergyContainer<TileEntityChargepad> energyContainer;

    public TileEntityChargepad() {
        super(MekanismBlocks.CHARGEPAD);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean active = false;
        List entities = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.field_174879_c.func_177956_o() + 0.4, (double)(this.field_174879_c.func_177952_p() + 1)), CHARGE_PREDICATE);
        for (LivingEntity entity : entities) {
            ItemStack stack;
            Optional itemHandlerCap;
            boolean bl = active = !this.energyContainer.isEmpty();
            if (!active) break;
            if (entity instanceof EntityRobit) {
                this.provideEnergy((EntityRobit)entity);
                continue;
            }
            if (!(entity instanceof PlayerEntity) || !(itemHandlerCap = MekanismUtils.toOptional(entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY))).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)itemHandlerCap.get();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots && ((stack = itemHandler.getStackInSlot(slot)).func_190926_b() || !this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler(stack))); ++slot) {
            }
        }
        if (active != this.getActive()) {
            this.setActive(active);
        }
    }

    private boolean provideEnergy(@Nullable IStrictEnergyHandler energyHandler) {
        FloatingLong extractedEnergy;
        if (energyHandler == null) {
            return false;
        }
        FloatingLong energyToGive = this.energyContainer.getEnergy();
        FloatingLong simulatedRemainder = energyHandler.insertEnergy(energyToGive, Action.SIMULATE);
        if (simulatedRemainder.smallerThan(energyToGive) && !(extractedEnergy = this.energyContainer.extract(energyToGive.subtract(simulatedRemainder), Action.EXECUTE, AutomationType.INTERNAL)).isZero()) {
            MekanismUtils.logExpectedZero(energyHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
            return true;
        }
        return false;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)this.func_174877_v().func_177958_n() + this.random.nextDouble(), (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void setActive(boolean active) {
        boolean wasActive = this.getActive();
        super.setActive(active);
        if (wasActive != active) {
            float pitch;
            SoundEvent sound;
            if (active) {
                sound = SoundEvents.field_187901_ga;
                pitch = 0.8f;
            } else {
                sound = SoundEvents.field_187847_fZ;
                pitch = 0.7f;
            }
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 0.3f, pitch);
        }
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }
}

