/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container;

import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.PacketUpdateContainer;
import net.minecraft.network.PacketBuffer;

public class PacketUpdateContainerGasStack
extends PacketUpdateContainer<PacketUpdateContainerGasStack> {
    @Nonnull
    private final GasStack value;

    public PacketUpdateContainerGasStack(short windowId, short property, @Nonnull GasStack value) {
        super(windowId, property);
        this.value = value;
    }

    private PacketUpdateContainerGasStack(PacketBuffer buffer) {
        super(buffer);
        this.value = ChemicalUtils.readGasStack(buffer);
    }

    @Override
    protected void encode(PacketBuffer buffer) {
        super.encode(buffer);
        ChemicalUtils.writeChemicalStack(buffer, this.value);
    }

    @Override
    protected void handle(MekanismContainer container, PacketUpdateContainerGasStack message) {
        container.handleWindowProperty(message.property, message.value);
    }

    public static PacketUpdateContainerGasStack decode(PacketBuffer buf) {
        return new PacketUpdateContainerGasStack(buf);
    }
}

