/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNewFilter {
    private final BlockPos pos;
    private final IFilter<?> filter;

    public PacketNewFilter(BlockPos pos, IFilter<?> filter) {
        this.pos = pos;
        this.filter = filter;
    }

    public static void handle(PacketNewFilter message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)player.field_70170_p, message.pos);
            if (message.filter instanceof TransporterFilter && tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).getFilters().add((TransporterFilter)message.filter);
            } else if (message.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).getFilters().add((MinerFilter)message.filter);
            } else if (message.filter instanceof TileEntityOredictionificator.OredictionificatorFilter && tile instanceof TileEntityOredictionificator) {
                ((TileEntityOredictionificator)tile).getFilters().add((TileEntityOredictionificator.OredictionificatorFilter)message.filter);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketNewFilter pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        pkt.filter.write(buf);
    }

    public static PacketNewFilter decode(PacketBuffer buf) {
        return new PacketNewFilter(buf.func_179259_c(), BaseFilter.readFromPacket(buf));
    }
}

