/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.entity.robit.InventoryRobitContainer;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import mekanism.common.inventory.container.entity.robit.SmeltingRobitContainer;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.inventory.container.tile.MatrixStatsTabContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.container.tile.SideConfigurationContainer;
import mekanism.common.inventory.container.tile.TransporterConfigurationContainer;
import mekanism.common.inventory.container.tile.UpgradeManagementContainer;
import mekanism.common.inventory.container.tile.filter.DMFilterSelectContainer;
import mekanism.common.inventory.container.tile.filter.DMItemStackFilterContainer;
import mekanism.common.inventory.container.tile.filter.DMMaterialFilterContainer;
import mekanism.common.inventory.container.tile.filter.DMModIDFilterContainer;
import mekanism.common.inventory.container.tile.filter.DMTagFilterContainer;
import mekanism.common.inventory.container.tile.filter.LSFilterSelectContainer;
import mekanism.common.inventory.container.tile.filter.LSItemStackFilterContainer;
import mekanism.common.inventory.container.tile.filter.LSMaterialFilterContainer;
import mekanism.common.inventory.container.tile.filter.LSModIDFilterContainer;
import mekanism.common.inventory.container.tile.filter.LSTagFilterContainer;
import mekanism.common.inventory.container.tile.filter.OredictionificatorFilterContainer;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketGuiButtonPress {
    private ClickedTileButton tileButton;
    private ClickedEntityButton entityButton;
    private boolean hasEntity;
    private int entityID;
    private int extra;
    private BlockPos tilePosition;

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile) {
        this(buttonClicked, tile.func_174877_v());
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, TileEntity tile, int extra) {
        this(buttonClicked, tile.func_174877_v(), extra);
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, int entityID) {
        this.entityButton = buttonClicked;
        this.hasEntity = true;
        this.entityID = entityID;
    }

    public static void handle(PacketGuiButtonPress message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            if (message.hasEntity) {
                INamedContainerProvider provider;
                Entity entity = player.field_70170_p.func_73045_a(message.entityID);
                if (entity != null && (provider = message.entityButton.getProvider(entity)) != null) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buf -> buf.func_150787_b(message.entityID));
                }
            } else {
                INamedContainerProvider provider;
                TileEntityMekanism tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.tilePosition);
                if (tile != null && (provider = message.tileButton.getProvider(tile, message.extra)) != null) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buf -> {
                        buf.func_179255_a(message.tilePosition);
                        buf.func_150787_b(message.extra);
                    });
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketGuiButtonPress pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.hasEntity);
        if (pkt.hasEntity) {
            buf.func_179249_a((Enum)pkt.entityButton);
            buf.func_150787_b(pkt.entityID);
        } else {
            buf.func_179249_a((Enum)pkt.tileButton);
            buf.func_179255_a(pkt.tilePosition);
            buf.func_150787_b(pkt.extra);
        }
    }

    public static PacketGuiButtonPress decode(PacketBuffer buf) {
        boolean hasEntity = buf.readBoolean();
        if (hasEntity) {
            return new PacketGuiButtonPress((ClickedEntityButton)buf.func_179257_a(ClickedEntityButton.class), buf.func_150792_a());
        }
        return new PacketGuiButtonPress((ClickedTileButton)buf.func_179257_a(ClickedTileButton.class), buf.func_179259_c(), buf.func_150792_a());
    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_CRAFTING, (i, inv, player) -> new CraftingRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_INVENTORY(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_INVENTORY, (i, inv, player) -> new InventoryRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_MAIN(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT, (i, inv, player) -> new MainRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_REPAIR(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_REPAIR, (i, inv, player) -> new RepairRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        }),
        ROBIT_SMELTING(entity -> {
            if (entity instanceof EntityRobit) {
                return new ContainerProvider(MekanismLang.ROBIT_SMELTING, (i, inv, player) -> new SmeltingRobitContainer(i, inv, (EntityRobit)entity));
            }
            return null;
        });

        private Function<Entity, INamedContainerProvider> providerFromEntity;

        private ClickedEntityButton(Function<Entity, INamedContainerProvider> providerFromEntity) {
            this.providerFromEntity = providerFromEntity;
        }

        public INamedContainerProvider getProvider(Entity entity) {
            return this.providerFromEntity.apply(entity);
        }
    }

    public static enum ClickedTileButton {
        BACK_BUTTON((tile, extra) -> {
            Block block = tile.getBlockType();
            if (Attribute.has(block, AttributeGui.class)) {
                return Attribute.get(block, AttributeGui.class).getProvider((TileEntityMekanism)tile);
            }
            return null;
        }),
        SIDE_CONFIGURATION((tile, extra) -> new ContainerProvider(MekanismLang.SIDE_CONFIG, (i, inv, player) -> new SideConfigurationContainer(i, inv, (TileEntityMekanism)tile))),
        TRANSPORTER_CONFIGURATION((tile, extra) -> new ContainerProvider(MekanismLang.TRANSPORTER_CONFIG, (i, inv, player) -> new TransporterConfigurationContainer(i, inv, (TileEntityMekanism)tile))),
        UPGRADE_MANAGEMENT((tile, extra) -> new ContainerProvider(MekanismLang.UPGRADES, (i, inv, player) -> new UpgradeManagementContainer(i, inv, (TileEntityMekanism)tile))),
        OREDICTIONIFICATOR_FILTER((tile, extra) -> {
            if (tile instanceof TileEntityOredictionificator) {
                return new ContainerProvider(MekanismLang.CREATE_FILTER_TITLE, (i, inv, player) -> new OredictionificatorFilterContainer(i, inv, (TileEntityOredictionificator)tile, (int)extra));
            }
            return null;
        }),
        DIGITAL_MINER_CONFIG((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.MINER_CONFIG, (i, inv, player) -> new DigitalMinerConfigContainer(i, inv, (TileEntityDigitalMiner)tile));
            }
            return null;
        }),
        DM_SELECT_FILTER_TYPE((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.CREATE_FILTER_TITLE, (i, inv, player) -> new DMFilterSelectContainer(i, inv, (TileEntityDigitalMiner)tile));
            }
            return null;
        }),
        DM_FILTER_ITEMSTACK((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.ITEM_FILTER, (i, inv, player) -> new DMItemStackFilterContainer(i, inv, (TileEntityDigitalMiner)tile, (int)extra));
            }
            return null;
        }),
        DM_FILTER_MATERIAL((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.MATERIAL_FILTER, (i, inv, player) -> new DMMaterialFilterContainer(i, inv, (TileEntityDigitalMiner)tile, (int)extra));
            }
            return null;
        }),
        DM_FILTER_MOD_ID((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.MODID_FILTER, (i, inv, player) -> new DMModIDFilterContainer(i, inv, (TileEntityDigitalMiner)tile, (int)extra));
            }
            return null;
        }),
        DM_FILTER_TAG((tile, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                return new ContainerProvider(MekanismLang.TAG_FILTER, (i, inv, player) -> new DMTagFilterContainer(i, inv, (TileEntityDigitalMiner)tile, (int)extra));
            }
            return null;
        }),
        LS_SELECT_FILTER_TYPE((tile, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                return new ContainerProvider(MekanismLang.CREATE_FILTER_TITLE, (i, inv, player) -> new LSFilterSelectContainer(i, inv, (TileEntityLogisticalSorter)tile));
            }
            return null;
        }),
        LS_FILTER_ITEMSTACK((tile, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                return new ContainerProvider(MekanismLang.ITEM_FILTER, (i, inv, player) -> new LSItemStackFilterContainer(i, inv, (TileEntityLogisticalSorter)tile, (int)extra));
            }
            return null;
        }),
        LS_FILTER_MATERIAL((tile, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                return new ContainerProvider(MekanismLang.MATERIAL_FILTER, (i, inv, player) -> new LSMaterialFilterContainer(i, inv, (TileEntityLogisticalSorter)tile, (int)extra));
            }
            return null;
        }),
        LS_FILTER_MOD_ID((tile, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                return new ContainerProvider(MekanismLang.MODID_FILTER, (i, inv, player) -> new LSModIDFilterContainer(i, inv, (TileEntityLogisticalSorter)tile, (int)extra));
            }
            return null;
        }),
        LS_FILTER_TAG((tile, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                return new ContainerProvider(MekanismLang.TAG_FILTER, (i, inv, player) -> new LSTagFilterContainer(i, inv, (TileEntityLogisticalSorter)tile, (int)extra));
            }
            return null;
        }),
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return new ContainerProvider(MekanismLang.MATRIX, (i, inv, player) -> new MekanismTileContainer<TileEntityInductionCasing>(MekanismContainerTypes.INDUCTION_MATRIX, i, inv, (TileEntityInductionCasing)tile));
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return new ContainerProvider(MekanismLang.BOILER, (i, inv, player) -> new MekanismTileContainer<TileEntityBoilerCasing>(MekanismContainerTypes.THERMOELECTRIC_BOILER, i, inv, (TileEntityBoilerCasing)tile));
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return new ContainerProvider(MekanismLang.MATRIX_STATS, (i, inv, player) -> new MatrixStatsTabContainer(i, inv, (TileEntityInductionCasing)tile));
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return new ContainerProvider(MekanismLang.BOILER_STATS, (i, inv, player) -> new EmptyTileContainer<TileEntityBoilerCasing>(MekanismContainerTypes.BOILER_STATS, i, inv, (TileEntityBoilerCasing)tile));
            }
            return null;
        });

        private BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

