/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SecurityInventorySlot
extends BasicInventorySlot {
    private static final Predicate<@NonNull ItemStack> validator = stack -> stack.func_77973_b() instanceof IOwnerItem;

    public static SecurityInventorySlot unlock(Supplier<UUID> ownerSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(ownerSupplier, "Owner supplier cannot be null");
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) == null, stack -> {
            UUID ownerUUID = ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack);
            return ownerUUID != null && ownerUUID.equals(ownerSupplier.get());
        }, inventory, x, y);
    }

    public static SecurityInventorySlot lock(@Nullable IMekanismInventory inventory, int x, int y) {
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) != null, stack -> ((IOwnerItem)stack.func_77973_b()).getOwnerUUID((ItemStack)stack) == null, inventory, x, y);
    }

    private SecurityInventorySlot(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, @Nullable IMekanismInventory inventory, int x, int y) {
        super(canExtract, canInsert, validator, inventory, x, y);
    }

    public void unlock(UUID ownerUUID) {
        IOwnerItem item;
        UUID stackOwner;
        if (!this.isEmpty() && this.current.func_77973_b() instanceof IOwnerItem && (stackOwner = (item = (IOwnerItem)this.current.func_77973_b()).getOwnerUUID(this.current)) != null && stackOwner.equals(ownerUUID)) {
            item.setOwnerUUID(this.current, null);
            if (item instanceof ISecurityItem) {
                ((ISecurityItem)item).setSecurity(this.current, ISecurityTile.SecurityMode.PUBLIC);
            }
        }
    }

    public void lock(UUID ownerUUID, SecurityFrequency frequency) {
        if (!this.isEmpty() && this.current.func_77973_b() instanceof IOwnerItem) {
            IOwnerItem item = (IOwnerItem)this.current.func_77973_b();
            UUID stackOwner = item.getOwnerUUID(this.current);
            if (stackOwner == null) {
                stackOwner = ownerUUID;
                item.setOwnerUUID(this.current, stackOwner);
            }
            if (stackOwner.equals(ownerUUID) && item instanceof ISecurityItem) {
                ((ISecurityItem)item).setSecurity(this.current, frequency.securityMode);
            }
        }
    }
}

