/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.integration.energy.fluxnetworks.FNIntegration;
import mekanism.common.integration.energy.fluxnetworks.FNStrictEnergyHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sonar.fluxnetworks.api.energy.FNEnergyCapability;

@ParametersAreNonnullByDefault
public class FNEnergyCompat
implements IEnergyCompat {
    @Override
    @Nonnull
    public Capability<?> getCapability() {
        return FNEnergyCapability.FN_ENERGY_STORAGE;
    }

    @Override
    public boolean isMatchingCapability(@Nonnull Capability<?> capability) {
        if (Mekanism.hooks.FluxNetworksLoaded) {
            return capability == FNEnergyCapability.FN_ENERGY_STORAGE;
        }
        return false;
    }

    @Override
    public boolean isUsable() {
        return !MekanismConfig.general.blacklistForge.get() && Mekanism.hooks.FluxNetworksLoaded && !MekanismConfig.general.blacklistFluxNetworks.get();
    }

    @Override
    public boolean isCapabilityPresent(ICapabilityProvider provider, @Nullable Direction side) {
        return CapabilityUtils.getCapability(provider, FNEnergyCapability.FN_ENERGY_STORAGE, side).isPresent();
    }

    @Override
    @Nonnull
    public LazyOptional<?> getHandlerAs(@Nonnull IStrictEnergyHandler handler) {
        return LazyOptional.of(() -> new FNIntegration(handler));
    }

    @Override
    @Nullable
    public IStrictEnergyHandler getStrictEnergyHandler(ICapabilityProvider provider, @Nullable Direction side) {
        return MekanismUtils.toOptional(CapabilityUtils.getCapability(provider, FNEnergyCapability.FN_ENERGY_STORAGE, side)).map(FNStrictEnergyHandler::new).orElse(null);
    }
}

