/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.heat;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.capabilities.holder.heat.ConfigHeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.util.Direction;

public class HeatCapacitorHelper {
    private final IHeatCapacitorHolder slotHolder;
    private boolean built;

    private HeatCapacitorHelper(IHeatCapacitorHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static HeatCapacitorHelper forSide(Supplier<Direction> facingSupplier) {
        return new HeatCapacitorHelper(new HeatCapacitorHolder(facingSupplier));
    }

    public static HeatCapacitorHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new HeatCapacitorHelper(new ConfigHeatCapacitorHolder(facingSupplier, configSupplier));
    }

    public void addCapacitor(@Nonnull IHeatCapacitor capacitor) {
        if (this.built) {
            throw new RuntimeException("Builder has already built.");
        }
        if (this.slotHolder instanceof HeatCapacitorHolder) {
            ((HeatCapacitorHolder)this.slotHolder).addCapacitor(capacitor, new RelativeSide[0]);
        } else if (this.slotHolder instanceof ConfigHeatCapacitorHolder) {
            ((ConfigHeatCapacitorHolder)this.slotHolder).addCapacitor(capacitor);
        }
    }

    public void addCapacitor(@Nonnull IHeatCapacitor container, RelativeSide ... sides) {
        if (this.built) {
            throw new RuntimeException("Builder has already built.");
        }
        if (this.slotHolder instanceof HeatCapacitorHolder) {
            ((HeatCapacitorHolder)this.slotHolder).addCapacitor(container, sides);
        }
    }

    public IHeatCapacitorHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

