/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.CapabilityCache;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ItemCapabilityWrapper
implements ICapabilityProvider {
    protected final ItemStack itemStack;
    private final List<ItemCapability> capabilities = new ArrayList<ItemCapability>();
    private boolean capabilitiesInitialized;

    public ItemCapabilityWrapper(ItemStack stack, ItemCapability ... caps) {
        this.itemStack = stack;
        for (ItemCapability c : caps) {
            c.wrapper = this;
            c.init();
            this.capabilities.add(c);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability != null && !this.itemStack.func_190926_b()) {
            if (!this.capabilitiesInitialized) {
                this.capabilitiesInitialized = true;
                for (ItemCapability cap : this.capabilities) {
                    cap.addCapabilityResolvers(cap.capabilityCache);
                }
            }
            for (ItemCapability cap : this.capabilities) {
                if (cap.capabilityCache.isCapabilityDisabled(capability, null)) {
                    return LazyOptional.empty();
                }
                if (!cap.capabilityCache.canResolve(capability)) continue;
                cap.load();
                return cap.capabilityCache.getCapabilityUnchecked(capability, null);
            }
        }
        return LazyOptional.empty();
    }

    public static abstract class ItemCapability {
        private final CapabilityCache capabilityCache = new CapabilityCache();
        private ItemCapabilityWrapper wrapper;

        protected abstract void addCapabilityResolvers(CapabilityCache var1);

        protected void init() {
        }

        protected void load() {
        }

        public ItemStack getStack() {
            return this.wrapper.itemStack;
        }
    }
}

