/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import javax.annotation.Nonnull;
import mekanism.api.IMekWrench;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockLogisticalSorter
extends BlockTile.BlockTileModel<TileEntityLogisticalSorter, Machine<TileEntityLogisticalSorter>> {
    public BlockLogisticalSorter() {
        super(MekanismBlockTypes.LOGISTICAL_SORTER);
    }

    @Override
    public void setTileData(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, @Nonnull TileEntityMekanism tile) {
        TileEntityLogisticalSorter transporter;
        if (tile instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tile).hasConnectedInventory()) {
            BlockPos tilePos = tile.func_174877_v();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                TileEntity tileEntity = MekanismUtils.getTileEntity((IBlockReader)world, tilePos.func_177972_a(dir));
                if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                transporter.setFacing(dir.func_176734_d());
                break;
            }
        }
    }

    @Override
    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntityLogisticalSorter tile = MekanismUtils.getTileEntity(TileEntityLogisticalSorter.class, (IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = MekanismUtils.getWrench(stack)) != null && wrenchHandler.canUseWrench(stack, player, hit.func_216350_a())) {
            if (SecurityUtils.canAccess(player, tile)) {
                if (player.func_225608_bj_()) {
                    MekanismUtils.dismantleBlock(state, world, pos);
                    return ActionResultType.SUCCESS;
                }
                Direction change = tile.getDirection().func_176746_e();
                if (!tile.hasConnectedInventory()) {
                    for (Direction dir : EnumUtils.DIRECTIONS) {
                        TileEntity tileEntity = MekanismUtils.getTileEntity((IBlockReader)world, pos.func_177972_a(dir));
                        if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                        change = dir.func_176734_d();
                        break;
                    }
                }
                tile.setFacing(change);
                world.func_195593_d(pos, (Block)this);
            } else {
                SecurityUtils.displayNoAccess(player);
            }
            return ActionResultType.SUCCESS;
        }
        return tile.openGui(player);
    }

    @Override
    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!world.field_72995_K) {
            TileEntityLogisticalSorter sorter;
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
            if (tile instanceof TileEntityMekanism) {
                ((TileEntityMekanism)tile).onNeighborChange(neighborBlock);
            }
            if (tile instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tile).hasConnectedInventory()) {
                for (Direction dir : EnumUtils.DIRECTIONS) {
                    TileEntity tileEntity = MekanismUtils.getTileEntity((IBlockReader)world, pos.func_177972_a(dir));
                    if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                    sorter.setFacing(dir.func_176734_d());
                    return;
                }
            }
        }
    }
}

