/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.sustained.ISustainedData;
import mekanism.api.sustained.ISustainedInventory;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.security.ISecurityItem;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class BlockMekanism
extends Block {
    protected BlockMekanism(Block.Properties properties) {
        super(properties);
        this.func_180632_j(BlockStateHelper.getDefaultState((BlockState)this.field_176227_L.func_177621_b()));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        TileEntityMekanism tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, world, pos);
        if (tile == null) {
            return itemStack;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ISecurityItem && tile.hasSecurity()) {
            ISecurityItem securityItem = (ISecurityItem)item;
            securityItem.setOwnerUUID(itemStack, tile.getSecurity().getOwnerUUID());
            securityItem.setSecurity(itemStack, tile.getSecurity().getMode());
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
            config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISustainedData) {
            ((ISustainedData)((Object)tile)).writeSustainedData(itemStack);
        }
        if (tile.supportsRedstone()) {
            ItemDataUtils.setInt(itemStack, "controlType", tile.getControlType().ordinal());
        }
        for (SubstanceType type : SubstanceType.values()) {
            if (!tile.handles(type)) continue;
            ItemDataUtils.setList(itemStack, type.getContainerTag(), type.getWriteFunction().apply(type.getContainers(tile)));
        }
        if (item instanceof ISustainedInventory && tile.persistInventory() && tile.getSlots() > 0) {
            ((ISustainedInventory)item).setInventory(tile.getInventory(new Object[0]), itemStack);
        }
        return itemStack;
    }

    public boolean hasTileEntity(BlockState state) {
        return this instanceof IHasTileEntity;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        if (this instanceof IHasTileEntity) {
            return ((IHasTileEntity)((Object)this)).getTileType().func_200968_a();
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.func_196258_a(context), context);
    }

    @Nonnull
    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        if (state.func_177230_c() instanceof IStateFluidLoggable) {
            return ((IStateFluidLoggable)state.func_177230_c()).getFluid(state);
        }
        return super.func_204507_t(state);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (state.func_177230_c() instanceof IStateFluidLoggable) {
            ((IStateFluidLoggable)state.func_177230_c()).updateFluids(state, world, currentPos);
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityMekanism tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos);
        if (tile == null) {
            return;
        }
        if (tile.supportsRedstone()) {
            tile.redstone = world.func_175640_z(pos);
        }
        if (tile instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tile)).onPlace();
        }
        if (!world.func_201670_d()) {
            if (tile instanceof IMultiblock) {
                ((IMultiblock)((Object)tile)).doUpdate();
            }
            if (tile instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)((Object)tile)).doUpdate();
            }
        }
        Item item = stack.func_77973_b();
        this.setTileData(world, pos, state, placer, stack, tile);
        if (item instanceof ISecurityItem && tile.hasSecurity()) {
            ISecurityItem securityItem = (ISecurityItem)item;
            tile.getSecurity().setMode(securityItem.getSecurity(stack));
            UUID ownerUUID = securityItem.getOwnerUUID(stack);
            tile.getSecurity().setOwnerUUID(ownerUUID == null ? placer.func_110124_au() : ownerUUID);
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().read(ItemDataUtils.getDataMap(stack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().read(ItemDataUtils.getDataMap(stack));
            config.getEjector().read(ItemDataUtils.getDataMap(stack));
        }
        for (SubstanceType type : SubstanceType.values()) {
            if (!type.canHandle(tile)) continue;
            type.getReadFunction().accept(type.getContainers(tile), ItemDataUtils.getList(stack, type.getContainerTag()));
        }
        if (tile instanceof ISustainedData && stack.func_77942_o()) {
            ((ISustainedData)((Object)tile)).readSustainedData(stack);
        }
        if (tile.supportsRedstone() && ItemDataUtils.hasData(stack, "controlType", 3)) {
            tile.setControlType(IRedstoneControl.RedstoneControl.byIndexStatic(ItemDataUtils.getInt(stack, "controlType")));
        }
        if (item instanceof ISustainedInventory && tile.persistInventory()) {
            tile.setInventory(((ISustainedInventory)item).getInventory(stack), new Object[0]);
        }
    }

    public void setTileData(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, TileEntityMekanism tile) {
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return BlockStateHelper.rotate(state, world, pos, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState func_185499_a(@Nonnull BlockState state, Rotation rotation) {
        return BlockStateHelper.rotate(state, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        return BlockStateHelper.mirror(state, mirror);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntityMekanism tile;
        if (state.hasTileEntity() && oldState.func_177230_c() != state.func_177230_c() && (tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos)) != null) {
            tile.onAdded();
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tile = MekanismUtils.getTileEntity((IBlockReader)world, pos)) instanceof IBoundingBlock) {
            ((IBoundingBlock)tile).onBreak();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState blockState) {
        return Attribute.has(this, Attributes.AttributeComparator.class);
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        IComparatorSupport comparatorTile;
        TileEntity tile;
        if (this.func_149740_M(blockState) && (tile = MekanismUtils.getTileEntity((IBlockReader)world, pos)) instanceof IComparatorSupport && (comparatorTile = (IComparatorSupport)tile).supportsComparator()) {
            return comparatorTile.getCurrentRedstoneLevel();
        }
        return 0;
    }
}

