/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockEnergyCube
extends BlockTile.BlockTileModel<TileEntityEnergyCube, Machine<TileEntityEnergyCube>> {
    private static final VoxelShape[] bounds = new VoxelShape[256];

    private static int getIndex(int top, int bottom, int front, int back, int left, int right, boolean rotateVertical, boolean rotateHorizontal) {
        return top | bottom << 1 | front << 2 | back << 3 | left << 4 | right << 5 | (rotateVertical ? 1 : 0) << 6 | (rotateHorizontal ? 1 : 0) << 7;
    }

    public BlockEnergyCube(Machine<TileEntityEnergyCube> type) {
        super(type, Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 4.0f).func_208770_d());
    }

    @Override
    public void setTileData(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, @Nonnull TileEntityMekanism tile) {
        IStrictEnergyHandler energyHandlerItem;
        Optional capability;
        ConfigInfo energyConfig;
        if (tile instanceof TileEntityEnergyCube && Attribute.getTier(this, EnergyCubeTier.class) == EnergyCubeTier.CREATIVE && (energyConfig = ((TileEntityEnergyCube)tile).configComponent.getConfig(TransmissionType.ENERGY)) != null && (capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY))).isPresent() && (energyHandlerItem = (IStrictEnergyHandler)capability.get()).getEnergyContainerCount() > 0) {
            energyConfig.fill(energyHandlerItem.getEnergy(0).isZero() ? DataType.INPUT : DataType.OUTPUT);
        }
    }

    @Override
    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int index;
        TileEntityEnergyCube energyCube = MekanismUtils.getTileEntity(TileEntityEnergyCube.class, world, pos, true);
        if (energyCube == null) {
            index = BlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
        } else {
            ConfigInfo energyConfig = energyCube.configComponent.getConfig(TransmissionType.ENERGY);
            if (energyConfig == null) {
                index = BlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
            } else {
                Direction facing = Attribute.get(this, AttributeStateFacing.class).getDirection(state);
                index = BlockEnergyCube.getIndex(BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.UP), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.DOWN), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.SOUTH), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.NORTH), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.EAST), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.WEST), facing == Direction.EAST || facing == Direction.WEST, facing == Direction.DOWN || facing == Direction.UP);
            }
        }
        return bounds[index];
    }

    private static int isSideEnabled(ConfigInfo energyConfig, Direction facing, Direction side) {
        ISlotInfo slotInfo = energyConfig.getSlotInfo(RelativeSide.fromDirections(facing, side));
        return slotInfo != null && slotInfo.isEnabled() ? 1 : 0;
    }

    static {
        VoxelShape frame = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0), BlockEnergyCube.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0), BlockEnergyCube.func_208617_a((double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), BlockEnergyCube.func_208617_a((double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), BlockEnergyCube.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), BlockEnergyCube.func_208617_a((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), BlockEnergyCube.func_208617_a((double)3.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), BlockEnergyCube.func_208617_a((double)3.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), BlockEnergyCube.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), BlockEnergyCube.func_208617_a((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), BlockEnergyCube.func_208617_a((double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), BlockEnergyCube.func_208617_a((double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), BlockEnergyCube.func_208617_a((double)12.5, (double)14.9, (double)7.5, (double)13.5, (double)15.9, (double)8.5), BlockEnergyCube.func_208617_a((double)2.5, (double)14.9, (double)7.5, (double)3.5, (double)15.9, (double)8.5), BlockEnergyCube.func_208617_a((double)12.5, (double)7.5, (double)0.1, (double)13.5, (double)8.5, (double)1.1), BlockEnergyCube.func_208617_a((double)2.5, (double)7.5, (double)0.1, (double)3.5, (double)8.5, (double)1.1), BlockEnergyCube.func_208617_a((double)2.5, (double)0.1, (double)7.5, (double)3.5, (double)1.1, (double)8.5), BlockEnergyCube.func_208617_a((double)12.5, (double)0.1, (double)7.5, (double)13.5, (double)1.1, (double)8.5), BlockEnergyCube.func_208617_a((double)12.5, (double)7.5, (double)14.9, (double)13.5, (double)8.5, (double)15.9), BlockEnergyCube.func_208617_a((double)2.5, (double)7.5, (double)14.9, (double)3.5, (double)8.5, (double)15.9), BlockEnergyCube.func_208617_a((double)0.1, (double)7.5, (double)2.5, (double)1.1, (double)8.5, (double)3.5), BlockEnergyCube.func_208617_a((double)0.1, (double)7.5, (double)12.5, (double)1.1, (double)8.5, (double)13.5), BlockEnergyCube.func_208617_a((double)14.9, (double)7.5, (double)2.5, (double)15.9, (double)8.5, (double)3.5), BlockEnergyCube.func_208617_a((double)14.9, (double)7.5, (double)12.5, (double)15.9, (double)8.5, (double)13.5));
        VoxelShape frontPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)15.0), BlockEnergyCube.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape rightPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)1.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0), BlockEnergyCube.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0));
        VoxelShape leftPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)14.0, (double)5.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), BlockEnergyCube.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        VoxelShape backPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)3.0, (double)5.0, (double)1.0, (double)13.0, (double)11.0, (double)2.0), BlockEnergyCube.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0));
        VoxelShape topPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)15.0, (double)11.0), BlockEnergyCube.func_208617_a((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        VoxelShape bottomPanel = VoxelShapeUtils.combine(BlockEnergyCube.func_208617_a((double)3.0, (double)1.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0), BlockEnergyCube.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0));
        VoxelShape frameRotated = VoxelShapeUtils.rotate(frame, Rotation.CLOCKWISE_90);
        VoxelShape topRotated = VoxelShapeUtils.rotate(topPanel, Rotation.CLOCKWISE_90);
        VoxelShape bottomRotated = VoxelShapeUtils.rotate(bottomPanel, Rotation.CLOCKWISE_90);
        VoxelShape frameRotatedAlt = VoxelShapeUtils.rotate(frame, Direction.NORTH);
        VoxelShape rightRotated = VoxelShapeUtils.rotate(rightPanel, Direction.NORTH);
        VoxelShape leftRotated = VoxelShapeUtils.rotate(leftPanel, Direction.NORTH);
        for (int rotated = 0; rotated < 3; ++rotated) {
            boolean rotateHorizontal;
            boolean rotateVertical = rotated == 1;
            boolean bl = rotateHorizontal = rotated == 2;
            VoxelShape baseFrame = rotateVertical ? frameRotated : (rotateHorizontal ? frameRotatedAlt : frame);
            for (int top = 0; top < 2; ++top) {
                VoxelShape withTop = top == 0 ? baseFrame : VoxelShapes.func_197872_a((VoxelShape)baseFrame, (VoxelShape)(rotateVertical ? topRotated : topPanel));
                for (int bottom = 0; bottom < 2; ++bottom) {
                    VoxelShape withBottom = bottom == 0 ? withTop : VoxelShapes.func_197872_a((VoxelShape)withTop, (VoxelShape)(rotateVertical ? bottomRotated : bottomPanel));
                    for (int front = 0; front < 2; ++front) {
                        VoxelShape withFront = front == 0 ? withBottom : VoxelShapes.func_197872_a((VoxelShape)withBottom, (VoxelShape)frontPanel);
                        for (int back = 0; back < 2; ++back) {
                            VoxelShape withBack = back == 0 ? withFront : VoxelShapes.func_197872_a((VoxelShape)withFront, (VoxelShape)backPanel);
                            for (int left = 0; left < 2; ++left) {
                                VoxelShape withLeft = left == 0 ? withBack : VoxelShapes.func_197872_a((VoxelShape)withBack, (VoxelShape)(rotateHorizontal ? leftRotated : leftPanel));
                                for (int right = 0; right < 2; ++right) {
                                    VoxelShape withRight;
                                    BlockEnergyCube.bounds[BlockEnergyCube.getIndex((int)top, (int)bottom, (int)front, (int)back, (int)left, (int)right, (boolean)rotateVertical, (boolean)rotateHorizontal)] = withRight = right == 0 ? withLeft : VoxelShapes.func_197872_a((VoxelShape)withLeft, (VoxelShape)(rotateHorizontal ? rightRotated : rightPanel));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

