/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class ItemStackToGasRecipeCategory
extends BaseRecipeCategory<ItemStackToGasRecipe> {
    public ItemStackToGasRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_OXIDIZER, 20, 12, 132, 62);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 133, 13));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 25, 35));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.LARGE_RIGHT, this, 64, 40));
    }

    public Class<? extends ItemStackToGasRecipe> getRecipeClass() {
        return ItemStackToGasRecipe.class;
    }

    public void setIngredients(ItemStackToGasRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getInput().getRepresentations()));
        ingredients.setOutput(MekanismJEI.TYPE_GAS, recipe.getOutputDefinition());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ItemStackToGasRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 25 - this.xOffset, 35 - this.yOffset);
        itemStacks.set(0, recipe.getInput().getRepresentations());
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, false, 134 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getOutputDefinition()), true);
    }
}

