/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.FluidGasToGasRecipe;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraftforge.fluids.FluidStack;

public class FluidGasToGasRecipeCategory
extends BaseRecipeCategory<FluidGasToGasRecipe> {
    public FluidGasToGasRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_WASHER, 3, 3, 170, 70);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 5, 4));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 26, 13));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 133, 13));
        this.guiElements.add(new GuiSlot(SlotType.POWER, this, 154, 4).with(SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 154, 55).with(SlotOverlay.MINUS));
        this.guiElements.add(new GuiProgress(() -> 1.0, ProgressType.LARGE_RIGHT, this, 64, 39));
    }

    public Class<? extends FluidGasToGasRecipe> getRecipeClass() {
        return FluidGasToGasRecipe.class;
    }

    public void setIngredients(FluidGasToGasRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidInput().getRepresentations()));
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.getGasInput().getRepresentations()));
        ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)recipe.getOutputRepresentation());
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidGasToGasRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        List fluidInputs = recipe.getFluidInput().getRepresentations();
        int max = fluidInputs.stream().mapToInt(FluidStack::getAmount).filter(input -> input >= 0).max().orElse(0);
        fluidStacks.init(0, true, 6 - this.xOffset, 5 - this.yOffset, 16, 58, max, false, this.fluidOverlayLarge);
        fluidStacks.set(0, fluidInputs);
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 27 - this.xOffset, 14 - this.yOffset, 16, 58, recipe.getGasInput().getRepresentations(), true);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 1, false, 134 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getOutputRepresentation()), true);
    }
}

