/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import mekanism.client.gui.robit.GuiRobit;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiRobitRepair
extends GuiRobit<RepairRobitContainer>
implements IContainerListener {
    private static final ResourceLocation ANVIL_RESOURCE = new ResourceLocation("textures/gui/container/anvil.png");
    private TextFieldWidget itemNameField;

    public GuiRobitRepair(RepairRobitContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.itemNameField = new TextFieldWidget(this.font, this.getGuiLeft() + 62, this.getGuiTop() + 24, 103, 12, "");
        this.addButton((Widget)this.itemNameField);
        this.itemNameField.func_146205_d(false);
        this.itemNameField.changeFocus(true);
        this.itemNameField.func_146193_g(-1);
        this.itemNameField.func_146204_h(-1);
        this.itemNameField.func_146185_a(false);
        this.itemNameField.func_146203_f(35);
        this.itemNameField.func_212954_a(this::onTextUpdate);
        ((RepairRobitContainer)this.field_147002_h).func_82847_b(this);
        ((RepairRobitContainer)this.field_147002_h).func_75132_a(this);
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.itemNameField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.itemNameField.func_146180_a(s);
    }

    private void onTextUpdate(String newText) {
        if (!newText.isEmpty()) {
            Slot slot = ((RepairRobitContainer)this.field_147002_h).func_75139_a(0);
            if (slot.func_75216_d() && !slot.func_75211_c().func_82837_s() && newText.equals(slot.func_75211_c().func_200301_q().getString())) {
                newText = "";
            }
            ((RepairRobitContainer)this.field_147002_h).func_82850_a(newText);
            this.minecraft.field_71439_g.field_71174_a.func_147297_a((IPacket)new CRenameItemPacket(newText));
        }
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
        ((RepairRobitContainer)this.field_147002_h).func_82847_b(this);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        this.drawString((ITextComponent)MekanismLang.ROBIT_REPAIR.translate(new Object[0]), 60, 6, 0x404040);
        int maximumCost = ((RepairRobitContainer)this.field_147002_h).func_216976_f();
        if (maximumCost > 0) {
            int k = 8453920;
            boolean flag = true;
            TranslationTextComponent component = MekanismLang.REPAIR_COST.translate(maximumCost);
            if (maximumCost >= 40 && !this.minecraft.field_71439_g.func_184812_l_()) {
                component = MekanismLang.REPAIR_EXPENSIVE.translate(new Object[0]);
                k = 0xFF6060;
            } else {
                Slot slot = ((RepairRobitContainer)this.field_147002_h).func_75139_a(2);
                if (!slot.func_75216_d()) {
                    flag = false;
                } else if (!slot.func_82869_a(this.field_213127_e.field_70458_d)) {
                    k = 0xFF6060;
                }
            }
            if (flag) {
                int width = this.getXSize() - 8 - this.getStringWidth((ITextComponent)component) - 2;
                GuiRobitRepair.fill((int)(width - 2), (int)67, (int)(this.getXSize() - 8), (int)79, (int)0x4F000000);
                this.font.func_175063_a(component.func_150254_d(), (float)width, 69.0f, k);
                MekanismRenderer.resetColor();
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.itemNameField.func_212955_f()) {
            return this.itemNameField.charTyped(c, keyCode);
        }
        return super.charTyped(c, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256 && this.itemNameField.func_212955_f()) {
            return this.itemNameField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean shouldOpenGui(GuiRobit.RobitGuiType guiType) {
        return guiType != GuiRobit.RobitGuiType.REPAIR;
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.minecraft.field_71446_o.func_110577_a(ANVIL_RESOURCE);
        this.blit(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        this.blit(this.getGuiLeft() + 59, this.getGuiTop() + 20, 0, this.getYSize() + (((RepairRobitContainer)this.field_147002_h).func_75139_a(0).func_75216_d() ? 0 : 16), 110, 16);
        if ((((RepairRobitContainer)this.field_147002_h).func_75139_a(0).func_75216_d() || ((RepairRobitContainer)this.field_147002_h).func_75139_a(1).func_75216_d()) && !((RepairRobitContainer)this.field_147002_h).func_75139_a(2).func_75216_d()) {
            this.blit(this.getGuiLeft() + 99, this.getGuiTop() + 45, this.getXSize(), 0, 28, 21);
        }
    }

    public void func_71110_a(@Nonnull Container container, @Nonnull NonNullList<ItemStack> list) {
        this.func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
    }

    public void func_71111_a(@Nonnull Container container, int slotID, @Nonnull ItemStack stack) {
        if (slotID == 0) {
            this.itemNameField.func_146180_a(stack.func_190926_b() ? "" : stack.func_200301_q().getString());
            this.itemNameField.func_146184_c(!stack.func_190926_b());
        }
    }

    public void func_71112_a(@Nonnull Container container, int varToUpdate, int newValue) {
    }
}

