/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiMaterialFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.miner.MMaterialFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.tile.filter.DMMaterialFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiMMaterialFilter
extends GuiMaterialFilter<MMaterialFilter, TileEntityDigitalMiner, DMMaterialFilterContainer> {
    public GuiMMaterialFilter(DMMaterialFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 33, 18, 111, 43));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18).setRenderHover(true));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 148, 18).setRenderHover(true));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!((MMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG);
            } else {
                this.status = MekanismLang.ITEM_FILTER_NO_ITEM.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.DM_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 148, this.getGuiTop() + 45, 14, 16, this.getButtonLocation("exclamation"), () -> {
            ((MMaterialFilter)this.filter).requireStack = !((MMaterialFilter)this.filter).requireStack;
        }, this.getOnHoverReplace((MinerFilter)this.filter)));
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (!((MMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
            this.renderScaledText(((MMaterialFilter)this.filter).getMaterialItem().func_200301_q(), 35, 41, 52480, 107);
        }
        this.drawMinerForegroundLayer(((MMaterialFilter)this.filter).getMaterialItem());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 0) {
            double yAxis;
            double xAxis = mouseX - (double)this.getGuiLeft();
            if (this.overTypeInput(xAxis, yAxis = mouseY - (double)this.getGuiTop())) {
                this.materialMouseClicked();
            } else {
                this.minerFilterClickCommon(xAxis, yAxis, (MinerFilter)this.filter);
            }
        }
        return true;
    }
}

