/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiConfigTypeTab
extends GuiInsetElement<TileEntity> {
    private final TransmissionType transmission;

    public GuiConfigTypeTab(IGuiWrapper gui, TransmissionType type, int x, int y) {
        super(GuiConfigTypeTab.getResource(type), gui, null, x, y, 26, 18);
        this.transmission = type;
    }

    private static ResourceLocation getResource(TransmissionType t) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, t.getTransmission() + ".png");
    }

    public TransmissionType getTransmissionType() {
        return this.transmission;
    }

    @Override
    protected void colorTab() {
        switch (this.transmission) {
            case ENERGY: {
                MekanismRenderer.color(EnumColor.DARK_GREEN);
                break;
            }
            case FLUID: {
                MekanismRenderer.color(EnumColor.DARK_BLUE);
                break;
            }
            case GAS: {
                MekanismRenderer.color(EnumColor.YELLOW);
                break;
            }
            case ITEM: {
                break;
            }
            case HEAT: {
                MekanismRenderer.color(EnumColor.ORANGE);
            }
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        this.displayTooltip((ITextComponent)TextComponentUtil.translate(this.transmission.getTranslationKey(), new Object[0]), mouseX, mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        ((GuiSideConfiguration)this.guiObj).setCurrentType(this.transmission);
        ((GuiSideConfiguration)this.guiObj).updateTabs();
    }
}

