/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.util.ResourceLocation;

public class GuiUpgradeScrollList
extends GuiScrollList {
    private static ResourceLocation UPGRADE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "upgrade_selection.png");
    private static int TEXTURE_WIDTH = 58;
    private static int TEXTURE_HEIGHT = 36;
    @Nullable
    private Upgrade selectedType;
    private final TileComponentUpgrade component;

    public GuiUpgradeScrollList(IGuiWrapper gui, int x, int y, int width, int height, TileComponentUpgrade component) {
        super(gui, x, y, width, height, TEXTURE_HEIGHT / 3, new GuiElementHolder(gui, x, y, width, height));
        this.component = component;
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.component.getInstalledTypes();
    }

    @Override
    protected int getMaxElements() {
        return this.getCurrentUpgrades().size();
    }

    @Override
    public boolean hasSelection() {
        return this.selectedType != null;
    }

    @Override
    protected void setSelected(int index) {
        Set<Upgrade> currentUpgrades = this.getCurrentUpgrades();
        if (index >= 0 && index < currentUpgrades.size()) {
            this.selectedType = currentUpgrades.toArray(new Upgrade[0])[index];
        }
    }

    @Nullable
    public Upgrade getSelection() {
        return this.selectedType;
    }

    @Override
    public void clearSelection() {
        this.selectedType = null;
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        int index;
        super.renderForeground(mouseX, mouseY, xAxis, yAxis);
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int multipliedElement = this.elementHeight * i;
            this.drawString(TextComponentUtil.build(upgrade), this.relativeX + 13, this.relativeY + 3 + multipliedElement, 0x404040);
            this.renderUpgrade(upgrade, this.relativeX + 3, this.relativeY + 3 + multipliedElement, 0.5f);
            if (mouseX < this.x + 1 || mouseX >= this.barX - 1 || mouseY < this.y + 1 + multipliedElement || mouseY > this.y + 1 + multipliedElement + this.elementHeight) continue;
            this.guiObj.displayTooltip(upgrade.getDescription(), xAxis, yAxis, this.guiObj.getWidth());
        }
    }

    @Override
    public void renderElements(int mouseX, int mouseY, float partialTicks) {
        int index;
        if (this.hasSelection() && this.component.getUpgrades(this.getSelection()) == 0) {
            this.clearSelection();
        }
        GuiUpgradeScrollList.minecraft.field_71446_o.func_110577_a(UPGRADE_SELECTION);
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int shiftedY = this.y + 1 + this.elementHeight * i;
            int j = 1;
            if (upgrade == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.x + 1 && mouseX < this.barX - 1 && mouseY >= shiftedY && mouseY <= shiftedY + this.elementHeight) {
                j = 0;
            }
            MekanismRenderer.color(upgrade.getColor(), 1.0f, 2.5f);
            GuiUpgradeScrollList.blit((int)(this.x + 1), (int)shiftedY, (float)0.0f, (float)(this.elementHeight * j), (int)TEXTURE_WIDTH, (int)this.elementHeight, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
            MekanismRenderer.resetColor();
        }
    }

    private void renderUpgrade(Upgrade type, int x, int y, float size) {
        this.guiObj.renderItem(UpgradeUtils.getStack(type), (int)((float)x / size), (int)((float)y / size), size);
    }
}

