/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;

public class GuiEnergyGauge
extends GuiGauge<Void> {
    private final IEnergyInfoHandler infoHandler;

    public GuiEnergyGauge(final IEnergyContainer container, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(new IEnergyInfoHandler(){

            @Override
            public FloatingLong getEnergy() {
                return container.getEnergy();
            }

            @Override
            public FloatingLong getMaxEnergy() {
                return container.getMaxEnergy();
            }
        }, type, gui, x, y);
    }

    public GuiEnergyGauge(IEnergyInfoHandler handler, GaugeType type, IGuiWrapper gui, int x, int y) {
        super(type, gui, x, y);
        this.infoHandler = handler;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.ENERGY;
    }

    @Override
    public int getScaledLevel() {
        if (this.infoHandler.getEnergy().equals(FloatingLong.MAX_VALUE)) {
            return this.height - 2;
        }
        return (int)((double)(this.height - 2) * this.infoHandler.getEnergy().divideToLevel(this.infoHandler.getMaxEnergy()));
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public ITextComponent getTooltipText() {
        if (this.infoHandler.getEnergy().isZero()) {
            return MekanismLang.EMPTY.translate(new Object[0]);
        }
        return EnergyDisplay.of(this.infoHandler.getEnergy(), this.infoHandler.getMaxEnergy()).getTextComponent();
    }

    public static interface IEnergyInfoHandler {
        public FloatingLong getEnergy();

        public FloatingLong getMaxEnergy();
    }
}

