/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.Slurry;
import mekanism.api.recipes.GasToItemStackRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.MekanismLang;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class GuiCrystallizerScreen
extends GuiTexturedElement {
    private static final SlotType SLOT = SlotType.ORE;
    private final GuiInnerScreen innerScreen;
    private final int slotX;
    private List<ItemStack> iterStacks = new ArrayList<ItemStack>();
    private ItemStack renderStack = ItemStack.field_190927_a;
    private int stackSwitch = 0;
    private int stackIndex = 0;
    @Nonnull
    private Gas prevGas = MekanismAPI.EMPTY_GAS;
    private IOreInfo oreInfo;

    public GuiCrystallizerScreen(IGuiWrapper gui, int x, int y, IOreInfo oreInfo) {
        super(SLOT.getTexture(), gui, x, y, 121, 42);
        this.innerScreen = new GuiInnerScreen(gui, x, y, this.width, this.height);
        this.oreInfo = oreInfo;
        this.slotX = this.x + 121 - SLOT.getWidth();
        this.active = false;
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        super.renderForeground(mouseX, mouseY, xAxis, yAxis);
        GasStack gasStack = this.oreInfo.getInputGas();
        if (!gasStack.isEmpty()) {
            this.drawString(TextComponentUtil.build(gasStack), 29, 15, 52480);
            if (gasStack.getType() instanceof Slurry && !this.renderStack.func_190926_b()) {
                this.drawString((ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translate(this.renderStack), 29, 24, 52480);
            } else {
                GasToItemStackRecipe recipe = this.oreInfo.getRecipe();
                if (recipe == null) {
                    this.drawString((ITextComponent)MekanismLang.NO_RECIPE.translate(new Object[0]), 29, 24, 52480);
                } else {
                    this.drawString((ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translate(recipe.getOutput(gasStack)), 29, 24, 52480);
                }
            }
        }
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.innerScreen.renderButton(mouseX, mouseY, partialTicks);
        GuiCrystallizerScreen.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiCrystallizerScreen.blit((int)this.slotX, (int)this.y, (float)0.0f, (float)0.0f, (int)SLOT.getWidth(), (int)SLOT.getHeight(), (int)SLOT.getWidth(), (int)SLOT.getHeight());
        if (!this.renderStack.func_190926_b()) {
            this.guiObj.renderItem(this.renderStack, this.slotX + 1, this.y + 1);
        }
    }

    public void tick() {
        Gas inputGas = (Gas)this.oreInfo.getInputGas().getType();
        if (this.prevGas != inputGas) {
            this.prevGas = inputGas;
            if (!this.prevGas.isEmptyType() && this.prevGas instanceof Slurry && !this.prevGas.isIn(MekanismTags.Gases.DIRTY_SLURRY)) {
                this.updateStackList(((Slurry)this.prevGas).getOreTag());
            } else {
                this.resetStacks();
            }
        }
        if (this.iterStacks.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
        } else {
            if (this.stackSwitch > 0) {
                --this.stackSwitch;
            }
            if (this.stackSwitch == 0) {
                this.stackSwitch = 20;
                if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                    this.stackIndex = 0;
                } else if (this.stackIndex < this.iterStacks.size() - 1) {
                    ++this.stackIndex;
                }
                this.renderStack = this.iterStacks.get(this.stackIndex);
            }
        }
    }

    private void resetStacks() {
        this.iterStacks.clear();
        this.renderStack = ItemStack.field_190927_a;
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    private void updateStackList(Tag<Item> oreTag) {
        this.iterStacks.clear();
        for (Item ore : oreTag.func_199885_a()) {
            this.iterStacks.add(new ItemStack((IItemProvider)ore));
        }
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    public static interface IOreInfo {
        @Nonnull
        public GasStack getInputGas();

        @Nullable
        public GasToItemStackRecipe getRecipe();
    }
}

