/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiTransporterConfig
extends GuiMekanismTile<TileEntityMekanism, EmptyTileContainer<TileEntityMekanism>> {
    private List<GuiSideConfiguration.GuiPos> slotPosList = new ArrayList<GuiSideConfiguration.GuiPos>();

    public GuiTransporterConfig(EmptyTileContainer<TileEntityMekanism> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g = 95;
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.BOTTOM, 54, 64));
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.TOP, 54, 34));
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.FRONT, 54, 49));
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.BACK, 39, 64));
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.LEFT, 39, 49));
        this.slotPosList.add(new GuiSideConfiguration.GuiPos(RelativeSide.RIGHT, 69, 49));
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 51, 15, 74, 12));
        this.addButton(new GuiInnerScreen(this, 53, 33, 16, 16));
        this.addButton(new GuiInnerScreen(this, 38, 48, 16, 16));
        this.addButton(new GuiInnerScreen(this, 68, 48, 16, 16));
        this.addButton(new GuiInnerScreen(this, 53, 63, 16, 16));
        this.addButton(new GuiInnerScreen(this, 38, 63, 16, 16));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 121, 48));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 6, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 156, this.getGuiTop() + 6, 14, this.getButtonLocation("strict_input"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v())), this.getOnHover(MekanismLang.STRICT_INPUT)));
        this.addButton(new ColorButton((IGuiWrapper)this, this.getGuiLeft() + 122, this.getGuiTop() + 49, 16, 16, () -> ((ISideConfiguration)this.getTile()).getEjector().getOutputColor(), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v(), GuiTransporterConfig.hasShiftDown() ? 2 : 0)), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v(), 1))));
        for (GuiSideConfiguration.GuiPos guiPos : this.slotPosList) {
            this.addButton(new SideDataButton(this, this.getGuiLeft() + guiPos.xPos, this.getGuiTop() + guiPos.yPos, guiPos.relativeSide, () -> ((ISideConfiguration)this.getTile()).getConfig().getDataType(TransmissionType.ITEM, guiPos.relativeSide), () -> ((ISideConfiguration)this.getTile()).getEjector().getInputColor(guiPos.relativeSide), this.tile, () -> null, PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, this.getOnHover()));
        }
    }

    public <TILE extends TileEntityMekanism> TILE getTile() {
        return (TILE)this.tile;
    }

    private GuiElement.IHoverable getOnHover() {
        return (onHover, xAxis, yAxis) -> {
            SideDataButton button;
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = (button = (SideDataButton)onHover).getDataType()) != null) {
                EnumColor color = button.getColor();
                if (color != null) {
                    this.displayTooltip(color.getColoredName(), xAxis, yAxis);
                } else {
                    this.displayTooltip((ITextComponent)MekanismLang.NONE.translate(new Object[0]), xAxis, yAxis);
                }
            }
        };
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)MekanismLang.TRANSPORTER_CONFIG.translate(new Object[0]), 0, this.getXSize(), 5, 0x404040);
        this.renderScaledText((ITextComponent)MekanismLang.STRICT_INPUT_ENABLED.translate(BooleanStateDisplay.OnOff.of(((ISideConfiguration)this.getTile()).getEjector().hasStrictInput())), 53, 17, 52480, 70);
        this.drawString((ITextComponent)MekanismLang.INPUT.translate(new Object[0]), 48, 81, 0x787878);
        this.drawString((ITextComponent)MekanismLang.OUTPUT.translate(new Object[0]), 114, 68, 0x787878);
        super.func_146979_b(mouseX, mouseY);
    }
}

