/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiThermalEvaporationController
extends GuiMekanismTile<TileEntityThermalEvaporationController, MekanismTileContainer<TileEntityThermalEvaporationController>> {
    public GuiThermalEvaporationController(MekanismTileContainer<TileEntityThermalEvaporationController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 48, 19, 80, 40));
        this.addButton(new GuiDownArrow(this, 32, 39));
        this.addButton(new GuiDownArrow(this, 136, 39));
        this.addButton(new GuiHorizontalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismUtils.getTemperatureDisplay(((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getTemp(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, ((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getTemp() / 3000.0);
            }
        }, 48, 63));
        this.addButton(new GuiFluidGauge(() -> ((TileEntityThermalEvaporationController)this.tile).inputTank, () -> ((TileEntityThermalEvaporationController)this.tile).getFluidTanks(null), GaugeType.STANDARD, this, 6, 13));
        this.addButton(new GuiFluidGauge(() -> ((TileEntityThermalEvaporationController)this.tile).outputTank, () -> ((TileEntityThermalEvaporationController)this.tile).getFluidTanks(null), GaugeType.STANDARD, this, 152, 13));
        this.addButton(new GuiHeatInfo(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityThermalEvaporationController)this.tile).totalLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 4, 0x404040);
        this.drawString(((TileEntityThermalEvaporationController)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityThermalEvaporationController)this.tile).getName()) / 2, 4, 0x404040);
        this.drawString((ITextComponent)this.getStruct().translate(new Object[0]), 50, 21, 52480);
        this.drawString((ITextComponent)MekanismLang.HEIGHT.translate(((TileEntityThermalEvaporationController)this.tile).height), 50, 30, 52480);
        this.drawString((ITextComponent)MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityThermalEvaporationController)this.tile).getTemp(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), 50, 39, 52480);
        this.renderScaledText((ITextComponent)MekanismLang.FLUID_PRODUCTION.translate((double)Math.round(((TileEntityThermalEvaporationController)this.tile).lastGain * 100.0) / 100.0), 50, 48, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    private ILangEntry getStruct() {
        if (((TileEntityThermalEvaporationController)this.tile).getActive()) {
            return MekanismLang.MULTIBLOCK_FORMED;
        }
        if (((TileEntityThermalEvaporationController)this.tile).controllerConflict) {
            return MekanismLang.MULTIBLOCK_CONFLICT;
        }
        return MekanismLang.MULTIBLOCK_INCOMPLETE;
    }
}

