/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSecurityLight;
import mekanism.client.gui.element.GuiTextureOnlyElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketAddTrusted;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiSecurityDesk
extends GuiMekanismTile<TileEntitySecurityDesk, MekanismTileContainer<TileEntitySecurityDesk>> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('-'), Character.valueOf('|'), Character.valueOf('_'));
    private MekanismButton removeButton;
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton trustedButton;
    private MekanismButton checkboxButton;
    private MekanismButton overrideButton;
    private GuiTextScrollList scrollList;
    private TextFieldWidget trustedField;

    public GuiSecurityDesk(MekanismTileContainer<TileEntitySecurityDesk> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 64;
        this.dynamicSlots = true;
    }

    @Override
    protected void initPreSlots() {
        this.addButton(new GuiInnerHolder(this, 141, 13, 26, 37));
        this.addButton(new GuiInnerHolder(this, 141, 54, 26, 34));
        this.addButton(new GuiInnerHolder(this, 141, 92, 26, 37));
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 34, 67, 89, 13));
        this.addButton(new GuiInnerScreen(this, 122, 67, 13, 13));
        this.addButton(new GuiSecurityLight(this, 144, 77, () -> ((TileEntitySecurityDesk)this.tile).frequency == null || ((TileEntitySecurityDesk)this.tile).ownerUUID == null || !((TileEntitySecurityDesk)this.tile).ownerUUID.equals(this.minecraft.field_71439_g.func_110124_au()) ? 2 : (((TileEntitySecurityDesk)this.tile).frequency.override ? 0 : 1)));
        this.addButton(new GuiTextureOnlyElement(PUBLIC, this, 146, 33, 18, 18));
        this.addButton(new GuiTextureOnlyElement(PRIVATE, this, 146, 112, 18, 18));
        this.scrollList = new GuiTextScrollList(this, 13, 13, 122, 42);
        this.addButton(this.scrollList);
        this.removeButton = new TranslationButton(this, this.getGuiLeft() + 13, this.getGuiTop() + 81, 122, 20, MekanismLang.BUTTON_REMOVE, () -> {
            int selection = this.scrollList.getSelection();
            if (((TileEntitySecurityDesk)this.tile).frequency != null && selection != -1) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.REMOVE_TRUSTED, this.tile, selection));
                this.scrollList.clearSelection();
                this.updateButtons();
            }
        });
        this.addButton(this.removeButton);
        this.trustedField = new TextFieldWidget(this.font, this.getGuiLeft() + 35, this.getGuiTop() + 69, 86, 11, "");
        this.addButton((Widget)this.trustedField);
        this.trustedField.func_146203_f(16);
        this.trustedField.func_146185_a(false);
        this.publicButton = new MekanismImageButton(this, this.getGuiLeft() + 13, this.getGuiTop() + 113, 40, 16, 40, 16, this.getButtonLocation("public"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, this.tile, ISecurityTile.SecurityMode.PUBLIC.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.PUBLIC_MODE));
        this.addButton(this.publicButton);
        this.privateButton = new MekanismImageButton(this, this.getGuiLeft() + 54, this.getGuiTop() + 113, 40, 16, 40, 16, this.getButtonLocation("private"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, this.tile, ISecurityTile.SecurityMode.PRIVATE.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.PRIVATE_MODE));
        this.addButton(this.privateButton);
        this.trustedButton = new MekanismImageButton(this, this.getGuiLeft() + 95, this.getGuiTop() + 113, 40, 16, 40, 16, this.getButtonLocation("trusted"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, this.tile, ISecurityTile.SecurityMode.TRUSTED.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.TRUSTED_MODE));
        this.addButton(this.trustedButton);
        this.checkboxButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 123, this.getGuiTop() + 68, 11, 12, this.getButtonLocation("checkmark"), () -> {
            this.addTrusted(this.trustedField.func_146179_b());
            this.trustedField.func_146180_a("");
            this.updateButtons();
        });
        this.addButton(this.checkboxButton);
        this.overrideButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 146, this.getGuiTop() + 59, 16, 16, this.getButtonLocation("exclamation"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.OVERRIDE_BUTTON, this.tile));
            this.updateButtons();
        }, (onHover, xAxis, yAxis) -> {
            if (((TileEntitySecurityDesk)this.tile).frequency != null) {
                this.displayTooltip((ITextComponent)MekanismLang.SECURITY_OVERRIDE.translate(BooleanStateDisplay.OnOff.of(((TileEntitySecurityDesk)this.tile).frequency.override)), xAxis, yAxis);
            }
        });
        this.addButton(this.overrideButton);
        this.updateButtons();
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.trustedField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.trustedField.func_146180_a(s);
    }

    private void addTrusted(String trusted) {
        if (PacketAddTrusted.validateNameLength(trusted.length())) {
            Mekanism.packetHandler.sendToServer(new PacketAddTrusted(((TileEntitySecurityDesk)this.tile).func_174877_v(), trusted));
        }
    }

    private void updateButtons() {
        if (((TileEntitySecurityDesk)this.tile).ownerUUID != null) {
            this.scrollList.setText(((TileEntitySecurityDesk)this.tile).frequency == null ? Collections.emptyList() : ((TileEntitySecurityDesk)this.tile).frequency.trustedCache);
            this.removeButton.active = this.scrollList.hasSelection();
        }
        if (((TileEntitySecurityDesk)this.tile).frequency != null && ((TileEntitySecurityDesk)this.tile).ownerUUID != null && ((TileEntitySecurityDesk)this.tile).ownerUUID.equals(this.minecraft.field_71439_g.func_110124_au())) {
            this.publicButton.active = ((TileEntitySecurityDesk)this.tile).frequency.securityMode != ISecurityTile.SecurityMode.PUBLIC;
            this.privateButton.active = ((TileEntitySecurityDesk)this.tile).frequency.securityMode != ISecurityTile.SecurityMode.PRIVATE;
            this.trustedButton.active = ((TileEntitySecurityDesk)this.tile).frequency.securityMode != ISecurityTile.SecurityMode.TRUSTED;
            this.checkboxButton.active = true;
            this.overrideButton.active = true;
        } else {
            this.publicButton.active = false;
            this.privateButton.active = false;
            this.trustedButton.active = false;
            this.checkboxButton.active = false;
            this.overrideButton.active = false;
        }
    }

    public void tick() {
        super.tick();
        this.updateButtons();
        this.trustedField.func_146178_a();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.trustedField.func_212955_f()) {
            if (keyCode == 256) {
                this.trustedField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.addTrusted(this.trustedField.func_146179_b());
                this.trustedField.func_146180_a("");
                return true;
            }
            return this.trustedField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.trustedField.func_212955_f()) {
            if (SPECIAL_CHARS.contains(Character.valueOf(c)) || Character.isDigit(c) || Character.isLetter(c)) {
                return this.trustedField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntitySecurityDesk)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntitySecurityDesk)this.tile).getName()) / 2, 4, 0x404040);
        ITextComponent ownerComponent = OwnerDisplay.of(((TileEntitySecurityDesk)this.tile).ownerUUID, ((TileEntitySecurityDesk)this.tile).clientOwner).getTextComponent();
        this.drawString(ownerComponent, this.getXSize() - 7 - this.getStringWidth(ownerComponent), this.getYSize() - 96 + 2, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        this.drawCenteredText((ITextComponent)MekanismLang.TRUSTED_PLAYERS.translate(new Object[0]), 74, 57, 0x787878);
        if (((TileEntitySecurityDesk)this.tile).frequency != null) {
            this.drawString((ITextComponent)MekanismLang.SECURITY.translate(((TileEntitySecurityDesk)this.tile).frequency.securityMode), 13, 103, 0x404040);
        } else {
            this.drawString(MekanismLang.SECURITY_OFFLINE.translateColored(EnumColor.RED, new Object[0]), 13, 103, 0x404040);
        }
        this.renderScaledText((ITextComponent)MekanismLang.SECURITY_ADD.translate(new Object[0]), 13, 70, 0x404040, 20);
        super.func_146979_b(mouseX, mouseY);
    }
}

