/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfuseTypeTags;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.recipes.inputs.InputIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public abstract class InfusionIngredient
implements InputIngredient<InfusionStack> {
    public static InfusionIngredient from(@Nonnull InfusionStack instance) {
        return InfusionIngredient.from((IInfuseTypeProvider)instance.getType(), instance.getAmount());
    }

    public static InfusionIngredient from(@Nonnull IInfuseTypeProvider infuseType, long amount) {
        return new Single(infuseType.getInfusionStack(amount));
    }

    public static InfusionIngredient from(@Nonnull Tag<InfuseType> infuseTypeTag, long amount) {
        return new Tagged(infuseTypeTag, amount);
    }

    @Override
    public abstract boolean testType(@Nonnull InfuseType var1);

    public static InfusionIngredient read(PacketBuffer buffer) {
        IngredientType type = (IngredientType)buffer.func_179257_a(IngredientType.class);
        if (type == IngredientType.SINGLE) {
            return Single.read(buffer);
        }
        if (type == IngredientType.TAGGED) {
            return Tagged.read(buffer);
        }
        return Multi.read(buffer);
    }

    public static InfusionIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined");
            }
            if (size > 1) {
                InfusionIngredient[] ingredients = new InfusionIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = InfusionIngredient.deserialize(jsonArray.get(i));
                }
                return InfusionIngredient.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("infuse_type") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("infuse_type")) {
            return InfusionIngredient.from(SerializerHelper.deserializeInfuseType(jsonObject));
        }
        if (jsonObject.has("tag")) {
            if (!jsonObject.has("amount")) {
                throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
            }
            JsonElement count = jsonObject.get("amount");
            if (!JSONUtils.func_188175_b((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
            }
            long amount = count.getAsJsonPrimitive().getAsLong();
            if (amount < 1L) {
                throw new JsonSyntaxException("Expected amount to be greater than zero.");
            }
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            Tag tag = InfuseTypeTags.getCollection().func_199910_a(resourceLocation);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown infuse type tag '" + resourceLocation + "'");
            }
            return InfusionIngredient.from((Tag<InfuseType>)tag, amount);
        }
        throw new JsonSyntaxException("Expected to receive a resource location representing either a tag or an infusion type.");
    }

    public static InfusionIngredient createMulti(InfusionIngredient ... ingredients) {
        if (ingredients.length != 0 && ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<InfusionIngredient> cleanedIngredients = new ArrayList<InfusionIngredient>();
        for (InfusionIngredient ingredient : ingredients) {
            if (ingredient instanceof Multi) {
                cleanedIngredients.addAll(Arrays.asList(((Multi)ingredient).ingredients));
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new Multi(cleanedIngredients.toArray(new InfusionIngredient[0]));
    }

    private static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    public static class Multi
    extends InfusionIngredient {
        private final InfusionIngredient[] ingredients;

        protected Multi(InfusionIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(@Nonnull InfusionStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@Nonnull InfusionStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public boolean testType(@Nonnull InfuseType infuseType) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(infuseType));
        }

        @Override
        @Nonnull
        public InfusionStack getMatchingInstance(@Nonnull InfusionStack stack) {
            for (InfusionIngredient ingredient : this.ingredients) {
                InfusionStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return InfusionStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull InfusionStack> getRepresentations() {
            ArrayList<@NonNull InfusionStack> representations = new ArrayList<InfusionStack>();
            for (InfusionIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.MULTI);
            buffer.func_150787_b(this.ingredients.length);
            for (InfusionIngredient ingredient : this.ingredients) {
                ingredient.write(buffer);
            }
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (InfusionIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        public static InfusionIngredient read(PacketBuffer buffer) {
            InfusionIngredient[] ingredients = new InfusionIngredient[buffer.func_150792_a()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = InfusionIngredient.read(buffer);
            }
            return Multi.createMulti(ingredients);
        }
    }

    public static class Tagged
    extends InfusionIngredient {
        @Nonnull
        private final Tag<InfuseType> tag;
        private final long amount;

        public Tagged(@Nonnull Tag<InfuseType> tag, long amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public boolean test(@Nonnull InfusionStack infusionStack) {
            return this.testType(infusionStack) && infusionStack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(@Nonnull InfusionStack infusionStack) {
            return this.testType((InfuseType)Objects.requireNonNull(infusionStack).getType());
        }

        @Override
        public boolean testType(@Nonnull InfuseType infuseType) {
            return Objects.requireNonNull(infuseType).isIn(this.tag);
        }

        @Override
        @Nonnull
        public InfusionStack getMatchingInstance(@Nonnull InfusionStack infusionStack) {
            if (this.test(infusionStack)) {
                return new InfusionStack(infusionStack, this.amount);
            }
            return InfusionStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull InfusionStack> getRepresentations() {
            ArrayList<@NonNull InfusionStack> representations = new ArrayList<InfusionStack>();
            for (InfuseType infuseType : this.tag.func_199885_a()) {
                representations.add(new InfusionStack(infuseType, this.amount));
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.TAGGED);
            buffer.func_192572_a(this.tag.func_199886_b());
            buffer.func_179254_b(this.amount);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("tag", this.tag.func_199886_b().toString());
            return json;
        }

        public static Tagged read(PacketBuffer buffer) {
            return new Tagged(new InfuseTypeTags.Wrapper(buffer.func_192575_l()), buffer.func_179260_f());
        }
    }

    public static class Single
    extends InfusionIngredient {
        @Nonnull
        private final InfusionStack infusionInstance;

        public Single(@Nonnull InfusionStack infusionInstance) {
            this.infusionInstance = infusionInstance;
        }

        @Override
        public boolean test(@Nonnull InfusionStack infuseObject) {
            return this.testType(infuseObject) && infuseObject.getAmount() >= this.infusionInstance.getAmount();
        }

        @Override
        public boolean testType(@Nonnull InfusionStack infuseObject) {
            return this.infusionInstance.isTypeEqual((ChemicalStack)Objects.requireNonNull(infuseObject));
        }

        @Override
        public boolean testType(@Nonnull InfuseType infuseType) {
            return this.infusionInstance.isTypeEqual((Chemical)Objects.requireNonNull(infuseType));
        }

        @Override
        @Nonnull
        public InfusionStack getMatchingInstance(@Nonnull InfusionStack infuseObject) {
            return this.test(infuseObject) ? this.infusionInstance.copy() : InfusionStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<@NonNull InfusionStack> getRepresentations() {
            return Collections.singletonList(this.infusionInstance);
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.SINGLE);
            this.infusionInstance.writeToPacket(buffer);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.infusionInstance.getAmount());
            json.addProperty("infuse_type", this.infusionInstance.getTypeRegistryName().toString());
            return json;
        }

        public static Single read(PacketBuffer buffer) {
            return new Single(InfusionStack.readFromPacket(buffer));
        }
    }
}

