/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class GasToItemStackCachedRecipe
extends CachedRecipe<GasToItemStackRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> inputHandler;

    public GasToItemStackCachedRecipe(GasToItemStackRecipe recipe, IInputHandler<@NonNull GasStack> inputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        GasStack recipeInput = this.inputHandler.getRecipeInput(((GasToItemStackRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((GasToItemStackRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((GasToItemStackRecipe)this.recipe).getOutput(recipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((GasToItemStackRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        GasStack recipeInput = this.inputHandler.getRecipeInput(((GasToItemStackRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeInput, operations);
        this.outputHandler.handleOutput(((GasToItemStackRecipe)this.recipe).getOutput(recipeInput), operations);
    }
}

