/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.inventory;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IInventorySlot
extends INBTSerializable<CompoundNBT> {
    public ItemStack getStack();

    public void setStack(ItemStack var1);

    default public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.func_190926_b() || !this.isItemValid(stack)) {
            return stack;
        }
        int needed = this.getLimit(stack) - this.getCount();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStack(), (ItemStack)stack))) {
            int toAdd = Math.min(stack.func_190916_E(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    ItemStack toSet = stack.func_77946_l();
                    toSet.func_190920_e(toAdd);
                    this.setStack(toSet);
                }
            }
            ItemStack remainder = stack.func_77946_l();
            remainder.func_190920_e(stack.func_190916_E() - toAdd);
            return remainder;
        }
        return stack;
    }

    default public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1) {
            return ItemStack.field_190927_a;
        }
        ItemStack current = this.getStack();
        int currentAmount = Math.min(this.getCount(), current.func_77976_d());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = current.func_77946_l();
        toReturn.func_190920_e(amount);
        if (action.execute()) {
            this.shrinkStack(amount, action);
        }
        return toReturn;
    }

    public int getLimit(ItemStack var1);

    public boolean isItemValid(ItemStack var1);

    public void onContentsChanged();

    @Nullable
    public Slot createContainerSlot();

    default public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setStack(ItemStack.field_190927_a);
            }
            return 0;
        }
        ItemStack stack = this.getStack();
        int maxStackSize = this.getLimit(stack);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stack.func_190916_E() == amount || action.simulate()) {
            return amount;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(amount);
        this.setStack(newStack);
        return amount;
    }

    default public int growStack(int amount, Action action) {
        int current = this.getCount();
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(this.getStack()));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public int shrinkStack(int amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getStack().func_190926_b();
    }

    default public int getCount() {
        return this.getStack().func_190916_E();
    }
}

