/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.IntSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import net.minecraft.network.PacketBuffer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalUtils {
    public static void writeChemicalStack(PacketBuffer buffer, ChemicalStack<?> stack) {
        if (stack.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            stack.writeToPacket(buffer);
        }
    }

    public static GasStack readGasStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? GasStack.readFromPacket(buffer) : GasStack.EMPTY;
    }

    public static InfusionStack readInfusionStack(PacketBuffer buffer) {
        return buffer.readBoolean() ? InfusionStack.readFromPacket(buffer) : InfusionStack.EMPTY;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insert(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, InsertChemical<CHEMICAL, STACK> insertChemical) {
        STACK remainder;
        int tank;
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return insertChemical.insert(0, stack, action);
        }
        IntArrayList matchingTanks = new IntArrayList();
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank2 = 0; tank2 < tanks; ++tank2) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.get(tank2);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank2);
                continue;
            }
            if (!inTank.isTypeEqual(stack)) continue;
            matchingTanks.add(tank2);
        }
        STACK toInsert = stack;
        IntListIterator intListIterator = matchingTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertChemical.insert(tank, toInsert, action);
            if (((ChemicalStack)remainder).isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertChemical.insert(tank, toInsert, action);
            if (((ChemicalStack)remainder).isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(long amount, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, ExtractChemical<CHEMICAL, STACK> extractChemical) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return extractChemical.extract(0, amount, action);
        }
        STACK extracted = empty;
        long toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            STACK drained;
            if (!extracted.isEmpty() && !extracted.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.get(tank))) || ((ChemicalStack)(drained = extractChemical.extract(tank, toDrain, action))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NonNull STACK> inTankGetter, ExtractChemical<CHEMICAL, STACK> extractChemical) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.get(0);
            if (inTank.isEmpty() || !inTank.isTypeEqual(stack)) {
                return empty;
            }
            return extractChemical.extract(0, stack.getAmount(), action);
        }
        STACK extracted = empty;
        long toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            STACK drained;
            if (!stack.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.get(tank))) || ((ChemicalStack)(drained = extractChemical.extract(tank, toDrain, action))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) == 0L) break;
        }
        return extracted;
    }

    @FunctionalInterface
    public static interface ExtractChemical<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> {
        public STACK extract(int var1, long var2, Action var4);
    }

    @FunctionalInterface
    public static interface InsertChemical<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> {
        public STACK insert(int var1, STACK var2, Action var3);
    }
}

