/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.TypeAdapter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.TypeAdapters;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.ForgeUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public final class RegistryEntryAdapter
implements TypeAdapter {
    private final Class<IForgeRegistryEntry<?>> registryEntryClass;
    private final boolean isArray;
    private IForgeRegistry<?> registry;

    public RegistryEntryAdapter(Class<IForgeRegistryEntry<?>> registryEntryClass, boolean isArray) {
        this.registryEntryClass = registryEntryClass;
        this.isArray = isArray;
    }

    @Override
    public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
        this.getRegistry();
        if (!this.isArray) {
            String locationString = (String)config.get(name);
            if (locationString.isEmpty()) {
                return defaultValue;
            }
            ResourceLocation location = new ResourceLocation(locationString.replaceAll("\\s", ""));
            return this.registry.containsKey(location) ? this.registry.getValue(location) : defaultValue;
        }
        List list = (List)config.get(name);
        ArrayList<IForgeRegistryEntry> values = new ArrayList<IForgeRegistryEntry>(list.size());
        for (String element : list) {
            IForgeRegistryEntry object = this.registry.getValue(new ResourceLocation(element.replaceAll("\\s", "")));
            if (object == null) continue;
            values.add(object);
        }
        return values.toArray((Object[])Array.newInstance(this.registryEntryClass, 0));
    }

    @Override
    public void setValue(CommentedFileConfig config, String name, Object value) {
        if (this.isArray) {
            config.set(name, Arrays.stream((Object[])value).map(this::asString).collect(Collectors.toList()));
        } else {
            config.set(name, (Object)this.asString(value));
        }
    }

    @Override
    public String asString(Object value) {
        return value == null ? "" : ((IForgeRegistryEntry)value).getRegistryName().toString();
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean shouldLoad() {
        return ForgeUtils.hasReachedStage(ModLoadingStage.COMMON_SETUP);
    }

    @Override
    public boolean canBeNull() {
        return true;
    }

    @Override
    public Object reloadDefault(Object defaultValue) {
        this.getRegistry();
        if (!this.isArray()) {
            if (defaultValue == null) {
                return null;
            }
            return this.registry.getValue(((IForgeRegistryEntry)defaultValue).getRegistryName());
        }
        Object[] oldDefaults = (Object[])defaultValue;
        ArrayList<IForgeRegistryEntry> newDefaults = new ArrayList<IForgeRegistryEntry>(oldDefaults.length);
        for (Object oldDefault : oldDefaults) {
            newDefaults.add(this.registry.getValue(((IForgeRegistryEntry)oldDefault).getRegistryName()));
        }
        return newDefaults.toArray(Arrays.copyOf(oldDefaults, 0));
    }

    private IForgeRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = RegistryManager.ACTIVE.getRegistry(this.registryEntryClass);
        }
        return this.registry;
    }

    public static void registerIfRegistryEntry(Class<?> clazz) {
        Class<IForgeRegistryEntry<?>> componentType;
        if (IForgeRegistryEntry.class.isAssignableFrom(clazz)) {
            RegistryEntryAdapter.register(clazz);
        } else if (clazz.isArray() && IForgeRegistryEntry.class.isAssignableFrom(componentType = clazz.getComponentType())) {
            RegistryEntryAdapter.register(componentType);
        }
    }

    static void initialize() {
        TypeAdapters.registerAutoRegistrar(RegistryEntryAdapter::registerIfRegistryEntry);
    }

    private static void register(Class<IForgeRegistryEntry<?>> clazz) {
        TypeAdapters.register(clazz, new RegistryEntryAdapter(clazz, false));
        TypeAdapters.register(Array.newInstance(clazz, 0).getClass(), new RegistryEntryAdapter(clazz, true));
    }
}

