/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.network.message;

import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.reference.Reference;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageResponseServerInfo {
    private int version;
    private List<TpsDimension> dims = new ArrayList<TpsDimension>();
    private int ping;
    private String versionString;

    public static void onMessage(final MessageResponseServerInfo message, Supplier<NetworkEvent.Context> context) {
        Minecraft.func_71410_x().func_222817_e(new Runnable(){

            @Override
            public void run() {
                GuiTabPage.responseVersion = message.version;
                GuiTabPage.dims = message.dims;
                GuiTabPage.ping = message.ping;
                GuiTabPage.serverVersion = message.versionString;
            }
        });
        context.get().setPacketHandled(true);
    }

    public MessageResponseServerInfo() {
    }

    public MessageResponseServerInfo(int version, List<TpsDimension> dims, int ping) {
        this.versionString = "";
        this.version = version;
        this.dims = dims;
        this.ping = ping;
    }

    public MessageResponseServerInfo(String serverVersion, int version, List<TpsDimension> dims, int ping) {
        this.versionString = serverVersion;
        this.version = version;
        this.dims = dims;
        this.ping = ping;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(Reference.getVersion());
        buf.writeInt(this.version);
        buf.writeInt(this.dims.size());
        for (TpsDimension s : this.dims) {
            buf.func_180714_a(s.name);
            buf.writeDouble(s.meanTickTime.doubleValue());
            buf.writeInt(s.Id);
        }
        buf.writeInt(this.ping);
    }

    public static MessageResponseServerInfo fromBytes(PacketBuffer buf) {
        ArrayList<TpsDimension> dims = new ArrayList<TpsDimension>();
        String versionString = buf.func_150789_c(Short.MAX_VALUE);
        int version = buf.readInt();
        for (int length = buf.readInt(); length != 0; --length) {
            dims.add(new TpsDimension(buf.func_150789_c(Short.MAX_VALUE), (Double)buf.readDouble(), buf.readInt()));
        }
        int ping = buf.readInt();
        return new MessageResponseServerInfo(versionString, version, dims, ping);
    }
}

