/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.TabulaModelRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedModelBox
extends ModelRenderer {
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public int field_78803_o;
    public int field_78813_p;
    public boolean scaleChildren;
    private AdvancedEntityModel model;
    private AdvancedModelBox parent;
    private int displayList;
    private boolean compiled;
    public ObjectList<TabulaModelRenderUtils.ModelBox> field_78804_l;
    public ObjectList<ModelRenderer> field_78805_m;
    private float textureWidth;
    private float textureHeight;
    private float offsetX;
    private float offsetY;
    private float offsetZ;

    public AdvancedModelBox(AdvancedEntityModel model, String name) {
        super((Model)model);
        this.textureWidth = model.field_78090_t;
        this.textureHeight = model.field_78089_u;
        this.model = model;
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
    }

    public AdvancedModelBox(AdvancedEntityModel model) {
        this(model, null);
        this.textureWidth = model.field_78090_t;
        this.textureHeight = model.field_78089_u;
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
    }

    public AdvancedModelBox(AdvancedEntityModel model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.textureWidth = model.field_78090_t;
        this.textureHeight = model.field_78089_u;
        this.setTextureOffset(textureOffsetX, textureOffsetY);
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
    }

    public ModelRenderer func_78787_b(int p_78787_1_, int p_78787_2_) {
        this.textureWidth = p_78787_1_;
        this.textureHeight = p_78787_2_;
        return this;
    }

    public ModelRenderer func_217178_a(String p_217178_1_, float p_217178_2_, float p_217178_3_, float p_217178_4_, int p_217178_5_, int p_217178_6_, int p_217178_7_, float p_217178_8_, int p_217178_9_, int p_217178_10_) {
        this.setTextureOffset(p_217178_9_, p_217178_10_);
        this.addBox(this.field_78803_o, this.field_78813_p, p_217178_2_, p_217178_3_, p_217178_4_, p_217178_5_, p_217178_6_, p_217178_7_, p_217178_8_, p_217178_8_, p_217178_8_, this.field_78809_i, false);
        return this;
    }

    public ModelRenderer func_228300_a_(float p_228300_1_, float p_228300_2_, float p_228300_3_, float p_228300_4_, float p_228300_5_, float p_228300_6_) {
        this.addBox(this.field_78803_o, this.field_78813_p, p_228300_1_, p_228300_2_, p_228300_3_, p_228300_4_, p_228300_5_, p_228300_6_, 0.0f, 0.0f, 0.0f, this.field_78809_i, false);
        return this;
    }

    public ModelRenderer func_228304_a_(float p_228304_1_, float p_228304_2_, float p_228304_3_, float p_228304_4_, float p_228304_5_, float p_228304_6_, boolean p_228304_7_) {
        this.addBox(this.field_78803_o, this.field_78813_p, p_228304_1_, p_228304_2_, p_228304_3_, p_228304_4_, p_228304_5_, p_228304_6_, 0.0f, 0.0f, 0.0f, p_228304_7_, false);
        return this;
    }

    public void func_228301_a_(float p_228301_1_, float p_228301_2_, float p_228301_3_, float p_228301_4_, float p_228301_5_, float p_228301_6_, float p_228301_7_) {
        this.addBox(this.field_78803_o, this.field_78813_p, p_228301_1_, p_228301_2_, p_228301_3_, p_228301_4_, p_228301_5_, p_228301_6_, p_228301_7_, p_228301_7_, p_228301_7_, this.field_78809_i, false);
    }

    public void func_228302_a_(float p_228302_1_, float p_228302_2_, float p_228302_3_, float p_228302_4_, float p_228302_5_, float p_228302_6_, float p_228302_7_, float p_228302_8_, float p_228302_9_) {
        this.addBox(this.field_78803_o, this.field_78813_p, p_228302_1_, p_228302_2_, p_228302_3_, p_228302_4_, p_228302_5_, p_228302_6_, p_228302_7_, p_228302_8_, p_228302_9_, this.field_78809_i, false);
    }

    public void func_228303_a_(float p_228303_1_, float p_228303_2_, float p_228303_3_, float p_228303_4_, float p_228303_5_, float p_228303_6_, float p_228303_7_, boolean p_228303_8_) {
        this.addBox(this.field_78803_o, this.field_78813_p, p_228303_1_, p_228303_2_, p_228303_3_, p_228303_4_, p_228303_5_, p_228303_6_, p_228303_7_, p_228303_7_, p_228303_7_, p_228303_8_, false);
    }

    private void addBox(int p_228305_1_, int p_228305_2_, float p_228305_3_, float p_228305_4_, float p_228305_5_, float p_228305_6_, float p_228305_7_, float p_228305_8_, float p_228305_9_, float p_228305_10_, float p_228305_11_, boolean p_228305_12_, boolean p_228305_13_) {
        this.field_78804_l.add((Object)new TabulaModelRenderUtils.ModelBox(p_228305_1_, p_228305_2_, p_228305_3_, p_228305_4_, p_228305_5_, p_228305_6_, p_228305_7_, p_228305_8_, p_228305_9_, p_228305_10_, p_228305_11_, p_228305_12_, this.textureWidth, this.textureHeight));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.field_78795_f;
        this.defaultRotationY = this.field_78796_g;
        this.defaultRotationZ = this.field_78808_h;
        this.defaultPositionX = this.field_78800_c;
        this.defaultPositionY = this.field_78797_d;
        this.defaultPositionZ = this.field_78798_e;
    }

    public void resetToDefaultPose() {
        this.field_78795_f = this.defaultRotationX;
        this.field_78796_g = this.defaultRotationY;
        this.field_78808_h = this.defaultRotationZ;
        this.field_78800_c = this.defaultPositionX;
        this.field_78797_d = this.defaultPositionY;
        this.field_78798_e = this.defaultPositionZ;
    }

    public void func_78792_a(ModelRenderer child) {
        super.func_78792_a(child);
        this.field_78805_m.add((Object)child);
        if (child instanceof AdvancedModelBox) {
            AdvancedModelBox advancedChild = (AdvancedModelBox)child;
            advancedChild.setParent(this);
        }
    }

    public AdvancedModelBox getParent() {
        return this.parent;
    }

    public void setParent(AdvancedModelBox parent) {
        this.parent = parent;
    }

    public void parentedPostRender(float scale) {
        if (this.parent != null) {
            this.parent.parentedPostRender(scale);
        }
    }

    public void renderWithParents(float scale) {
        if (this.parent != null) {
            this.parent.renderWithParents(scale);
        }
    }

    public void func_228309_a_(MatrixStack p_228309_1_, IVertexBuilder p_228309_2_, int p_228309_3_, int p_228309_4_, float p_228309_5_, float p_228309_6_, float p_228309_7_, float p_228309_8_) {
        if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
            p_228309_1_.func_227860_a_();
            this.func_228307_a_(p_228309_1_);
            this.doRender(p_228309_1_.func_227866_c_(), p_228309_2_, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            for (ModelRenderer lvt_10_1_ : this.field_78805_m) {
                lvt_10_1_.func_228309_a_(p_228309_1_, p_228309_2_, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            }
            p_228309_1_.func_227865_b_();
        }
    }

    private void doRender(MatrixStack.Entry p_228306_1_, IVertexBuilder p_228306_2_, int p_228306_3_, int p_228306_4_, float p_228306_5_, float p_228306_6_, float p_228306_7_, float p_228306_8_) {
        Matrix4f lvt_9_1_ = p_228306_1_.func_227870_a_();
        Matrix3f lvt_10_1_ = p_228306_1_.func_227872_b_();
        for (TabulaModelRenderUtils.ModelBox lvt_12_1_ : this.field_78804_l) {
            for (TabulaModelRenderUtils.TexturedQuad lvt_16_1_ : lvt_12_1_.quads) {
                Vector3f lvt_17_1_ = lvt_16_1_.normal.func_229195_e_();
                lvt_17_1_.func_229188_a_(lvt_10_1_);
                float lvt_18_1_ = lvt_17_1_.func_195899_a();
                float lvt_19_1_ = lvt_17_1_.func_195900_b();
                float lvt_20_1_ = lvt_17_1_.func_195902_c();
                for (int lvt_21_1_ = 0; lvt_21_1_ < 4; ++lvt_21_1_) {
                    TabulaModelRenderUtils.PositionTextureVertex lvt_22_1_ = lvt_16_1_.vertexPositions[lvt_21_1_];
                    float lvt_23_1_ = lvt_22_1_.position.func_195899_a() / 16.0f;
                    float lvt_24_1_ = lvt_22_1_.position.func_195900_b() / 16.0f;
                    float lvt_25_1_ = lvt_22_1_.position.func_195902_c() / 16.0f;
                    Vector4f lvt_26_1_ = new Vector4f(lvt_23_1_, lvt_24_1_, lvt_25_1_, 1.0f);
                    lvt_26_1_.func_229372_a_(lvt_9_1_);
                    p_228306_2_.func_225588_a_(lvt_26_1_.func_195910_a(), lvt_26_1_.func_195913_b(), lvt_26_1_.func_195914_c(), p_228306_5_, p_228306_6_, p_228306_7_, p_228306_8_, lvt_22_1_.textureU, lvt_22_1_.textureV, p_228306_4_, p_228306_3_, lvt_18_1_, lvt_19_1_, lvt_20_1_);
                }
            }
        }
    }

    public AdvancedEntityModel getModel() {
        return this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float rotation = MathHelper.func_76134_b((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.field_78795_f += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.field_78808_h += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.field_78796_g += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.field_78797_d += bob;
    }

    public AdvancedModelBox setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.field_78803_o = textureOffsetX;
        this.field_78813_p = textureOffsetY;
        return this;
    }

    public void transitionTo(AdvancedModelBox to, float timer, float maxTime) {
        this.field_78795_f += (to.field_78795_f - this.field_78795_f) / maxTime * timer;
        this.field_78796_g += (to.field_78796_g - this.field_78796_g) / maxTime * timer;
        this.field_78808_h += (to.field_78808_h - this.field_78808_h) / maxTime * timer;
        this.field_78800_c += (to.field_78800_c - this.field_78800_c) / maxTime * timer;
        this.field_78797_d += (to.field_78797_d - this.field_78797_d) / maxTime * timer;
        this.field_78798_e += (to.field_78798_e - this.field_78798_e) / maxTime * timer;
        this.offsetX += (to.offsetX - this.offsetX) / maxTime * timer;
        this.offsetY += (to.offsetY - this.offsetY) / maxTime * timer;
        this.offsetZ += (to.offsetZ - this.offsetZ) / maxTime * timer;
    }
}

