/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.tweaks.module.CompassesWorkEverywhereModule;

public class CompassAngleGetter
implements IItemPropertyGetter {
    private static final String TAG_CALCULATED = "quark:compass_calculated";
    private static final String TAG_WAS_IN_NETHER = "quark:compass_in_nether";
    private static final String TAG_POSITION_SET = "quark:compass_position_set";
    private static final String TAG_NETHER_TARGET_X = "quark:nether_x";
    private static final String TAG_NETHER_TARGET_Z = "quark:nether_z";
    private double rotation;
    private double rota;
    private long lastUpdateTick;

    public static void tickCompass(PlayerEntity player, ItemStack stack) {
        boolean nether;
        boolean calculated = CompassAngleGetter.isCalculated(stack);
        boolean bl = nether = player.field_70170_p.field_73011_w.func_186058_p() == DimensionType.field_223228_b_;
        if (calculated) {
            boolean isInPortal;
            boolean wasInNether = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
            BlockPos pos = player.func_180425_c();
            boolean bl2 = isInPortal = player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO;
            if (nether && !wasInNether && isInPortal) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)pos.func_177958_n());
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)pos.func_177952_p());
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)true);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)true);
            } else if (!nether && wasInNether) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false);
            }
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)nether);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float call(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        double angle;
        boolean set;
        LivingEntity entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        if (!(!CompassesWorkEverywhereModule.enableCompassNerf || stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false))) {
            return 0.0f;
        }
        boolean carried = entityIn != null;
        Object object = entity = carried ? entityIn : stack.func_82836_z();
        if (entity == null) {
            return 0.0f;
        }
        if (worldIn == null) {
            worldIn = entity.field_70170_p;
        }
        boolean calculate = false;
        BlockPos target = new BlockPos(0, 0, 0);
        Dimension dimension = worldIn.field_73011_w;
        if (dimension.func_76569_d()) {
            calculate = true;
            target = worldIn.func_175694_M();
        } else if (dimension.func_186058_p() == DimensionType.field_223229_c_ && CompassesWorkEverywhereModule.enableEnd) {
            calculate = true;
        } else if (dimension.func_186058_p() == DimensionType.field_223228_b_ && CompassAngleGetter.isCalculated(stack) && CompassesWorkEverywhereModule.enableNether && (set = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false))) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)0);
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)0);
            calculate = true;
            target = new BlockPos(x, 0, z);
        }
        if (calculate) {
            double d1 = carried ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
            d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
            double d2 = this.getAngleToPosition((Entity)entity, target) / (Math.PI * 2);
            angle = 0.5 - (d1 - 0.25 - d2);
        } else {
            angle = Math.random();
        }
        if (carried) {
            angle = this.wobble(worldIn, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    private double wobble(World worldIn, double angle) {
        long gameTime = worldIn.func_82737_E();
        if (gameTime != this.lastUpdateTick) {
            this.lastUpdateTick = gameTime;
            double d0 = angle - this.rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }

    private double getFrameRotation(ItemFrameEntity frame) {
        return MathHelper.func_76142_g((float)(180.0f + frame.func_174811_aO().func_185119_l()));
    }

    private double getAngleToPosition(Entity entity, BlockPos blockpos) {
        Vec3d pos = entity.func_213303_ch();
        return Math.atan2((double)blockpos.func_177952_p() - pos.field_72449_c, (double)blockpos.func_177958_n() - pos.field_72450_a);
    }
}

