/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import vazkii.quark.automation.base.RandomizerPowerState;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.Module;

public class RedstoneRandomizerBlock
extends QuarkBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<RandomizerPowerState> POWERED = EnumProperty.func_177709_a((String)"powered", RandomizerPowerState.class);

    public RedstoneRandomizerBlock(String regname, Module module, ItemGroup creativeTab, Block.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(POWERED, (Comparable)((Object)RandomizerPowerState.OFF)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered((World)world, pos, state))) {
            state = !willBePowered ? (BlockState)state.func_206870_a(POWERED, (Comparable)((Object)RandomizerPowerState.OFF)) : (BlockState)state.func_206870_a(POWERED, (Comparable)((Object)(rand.nextBoolean() ? RandomizerPowerState.LEFT : RandomizerPowerState.RIGHT)));
            world.func_175656_a(pos, state);
        }
    }

    protected void updateState(World world, BlockPos pos, BlockState state) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered(world, pos, state)) && !world.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority priority = isPowered ? TickPriority.VERY_HIGH : TickPriority.HIGH;
            world.func_205220_G_().func_205362_a(pos, (Object)this, 2, priority);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, POWERED});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return RedstoneRandomizerBlock.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    protected boolean isPowered(BlockState state) {
        return state.func_177229_b(POWERED) != RandomizerPowerState.OFF;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        RandomizerPowerState powerState = (RandomizerPowerState)((Object)blockState.func_177229_b(POWERED));
        switch (powerState) {
            case RIGHT: {
                return ((Direction)blockState.func_177229_b((IProperty)FACING)).func_176746_e() == side ? 15 : 0;
            }
            case LEFT: {
                return ((Direction)blockState.func_177229_b((IProperty)FACING)).func_176735_f() == side ? 15 : 0;
            }
        }
        return 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)world, pos)) {
            this.updateState(world, pos, state);
        } else {
            RedstoneRandomizerBlock.breakAndDrop((Block)this, state, world, pos);
        }
    }

    public static void breakAndDrop(Block block, BlockState state, World world, BlockPos pos) {
        RedstoneRandomizerBlock.func_220059_a((BlockState)state, (World)world, (BlockPos)pos, null);
        world.func_217377_a(pos, false);
        for (Direction direction : Direction.values()) {
            world.func_195593_d(pos.func_177972_a(direction), block);
        }
    }

    protected boolean shouldBePowered(World world, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(world, pos, state) > 0;
    }

    protected int calculateInputStrength(World world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos checkPos = pos.func_177972_a(face);
        int strength = world.func_175651_c(checkPos, face);
        if (strength >= 15) {
            return strength;
        }
        BlockState checkState = world.func_180495_p(checkPos);
        return Math.max(strength, checkState.func_177230_c() == Blocks.field_150488_af ? (Integer)checkState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O) : 0);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldBePowered(world, pos, state)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, false);
            RedstoneRandomizerBlock.notifyNeighbors((Block)this, world, pos, state);
        }
    }

    public static void notifyNeighbors(Block block, World world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos neighborPos = pos.func_177972_a(face.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), EnumSet.of(face.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        world.func_190524_a(neighborPos, block, pos);
        world.func_175695_a(neighborPos, block, face);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(POWERED) != RandomizerPowerState.OFF) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.4f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

