/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.SimulateResultImpl;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

public class SparseMultiblock
extends AbstractMultiblock {
    private final Map<BlockPos, IStateMatcher> data;
    private final Vec3i size;

    public SparseMultiblock(Map<BlockPos, IStateMatcher> data) {
        Preconditions.checkArgument((!data.isEmpty() ? 1 : 0) != 0, (Object)"No data given to sparse multiblock!");
        this.data = ImmutableMap.copyOf(data);
        this.size = this.calculateSize();
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }

    private Vec3i calculateSize() {
        int minX = this.data.keySet().stream().mapToInt(Vec3i::func_177958_n).min().getAsInt();
        int maxX = this.data.keySet().stream().mapToInt(Vec3i::func_177958_n).max().getAsInt();
        int minY = this.data.keySet().stream().mapToInt(Vec3i::func_177956_o).min().getAsInt();
        int maxY = this.data.keySet().stream().mapToInt(Vec3i::func_177956_o).max().getAsInt();
        int minZ = this.data.keySet().stream().mapToInt(Vec3i::func_177952_p).min().getAsInt();
        int maxZ = this.data.keySet().stream().mapToInt(Vec3i::func_177952_p).max().getAsInt();
        return new Vec3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
    }

    public BlockState func_180495_p(BlockPos pos) {
        int ticks = this.world != null ? (int)this.world.func_72820_D() : 0;
        return this.data.getOrDefault(pos, StateMatcher.AIR).getDisplayedState(ticks);
    }

    @Override
    public Pair<BlockPos, Collection<IMultiblock.SimulateResult>> simulate(World world, BlockPos anchor, Rotation rotation, boolean forView) {
        BlockPos center = forView ? anchor.func_177982_a(RotationUtil.x(rotation, -this.viewOffX, -this.viewOffZ), -this.viewOffY + 1, RotationUtil.z(rotation, -this.viewOffX, -this.viewOffZ)) : anchor.func_177982_a(RotationUtil.x(rotation, -this.offX, -this.offZ), -this.offY, RotationUtil.z(rotation, -this.offX, -this.offZ));
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (Map.Entry<BlockPos, IStateMatcher> e : this.data.entrySet()) {
            BlockPos actionPos = center.func_177982_a(RotationUtil.x(rotation, e.getKey().func_177958_n(), e.getKey().func_177952_p()), e.getKey().func_177956_o(), RotationUtil.z(rotation, e.getKey().func_177958_n(), e.getKey().func_177952_p()));
            ret.add(new SimulateResultImpl(actionPos, e.getValue(), null));
        }
        return Pair.of((Object)center, ret);
    }

    @Override
    public boolean test(World world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setWorld(world);
        BlockPos checkPos = start.func_177982_a(RotationUtil.x(rotation, x, z), y, RotationUtil.z(rotation, x, z));
        BlockState state = world.func_180495_p(checkPos).func_185907_a(RotationUtil.fixHorizontal(rotation));
        IStateMatcher matcher = this.data.getOrDefault(new BlockPos(x, y, z), StateMatcher.ANY);
        return matcher.getStatePredicate().test((Object)world, (Object)checkPos, (Object)state);
    }
}

