/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.conveyor;

import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class ConveyorUpgrade
implements INBTSerializable<CompoundNBT> {
    private IConveyorContainer container;
    private ConveyorUpgradeFactory factory;
    private Direction side;

    public ConveyorUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, Direction side) {
        this.container = container;
        this.factory = factory;
        this.side = side;
    }

    public CompoundNBT serializeNBT() {
        return null;
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }

    public boolean onUpgradeActivated(PlayerEntity player, Hand hand) {
        return false;
    }

    public Collection<ItemStack> getDrops() {
        return Collections.singleton(new ItemStack((IItemProvider)this.getFactory().getUpgradeItem(), 1));
    }

    public IConveyorContainer getContainer() {
        return this.container;
    }

    public World getWorld() {
        return this.getContainer().getConveyorWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getConveyorPosition();
    }

    public ConveyorUpgradeFactory getFactory() {
        return this.factory;
    }

    public Direction getSide() {
        return this.side;
    }

    public void update() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public VoxelShape getBoundingBox() {
        return VoxelShapes.func_197880_a();
    }

    public boolean hasGui() {
        return false;
    }

    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
    }

    public void addComponentsToGui(List<IGuiComponent> componentList) {
    }
}

