/*
 * Decompiled with CFR 0.152.
 */
package com.snowshock35.jeiintegration;

import com.snowshock35.jeiintegration.config.Config;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TooltipEventHandler {
    private Config.Client config = Config.CLIENT;

    private static boolean isDebugMode() {
        return Minecraft.func_71410_x().field_71474_y.field_82882_x;
    }

    private static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        CompoundNBT nbtData;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        ItemStack itemStack = e.getItemStack();
        Item item = itemStack.func_77973_b();
        if (e.getItemStack().func_190926_b()) {
            return;
        }
        int burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack);
        if (burnTime > 0) {
            ITextComponent burnTooltip = new TranslationTextComponent("tooltip.jeiintegration.burnTime", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + decimalFormat.format(burnTime) + " ")).func_150257_a((ITextComponent)new TranslationTextComponent("tooltip.jeiintegration.burnTime.suffix", new Object[0])).func_211708_a(TextFormatting.DARK_GRAY);
            if (Objects.equals(this.config.burnTimeTooltipMode.get(), "enabled")) {
                e.getToolTip().add(burnTooltip);
            } else if (Objects.equals(this.config.burnTimeTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(burnTooltip);
            } else if (Objects.equals(this.config.burnTimeTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(burnTooltip);
            } else if (Objects.equals(this.config.burnTimeTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(burnTooltip);
            }
        }
        int maxDamage = itemStack.func_77958_k();
        int currentDamage = maxDamage - itemStack.func_77952_i();
        if (maxDamage > 0) {
            ITextComponent durabilityTooltip = new TranslationTextComponent("tooltip.jeiintegration.durability", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + currentDamage + "/" + maxDamage)).func_211708_a(TextFormatting.DARK_GRAY);
            if (Objects.equals(this.config.durabilityTooltipMode.get(), "enabled")) {
                e.getToolTip().add(1, durabilityTooltip);
            } else if (Objects.equals(this.config.durabilityTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(1, durabilityTooltip);
            } else if (Objects.equals(this.config.durabilityTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(1, durabilityTooltip);
            } else if (Objects.equals(this.config.durabilityTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(1, durabilityTooltip);
            }
        }
        if (item.func_219971_r()) {
            int healVal = item.func_219967_s().func_221466_a();
            float satVal = (float)healVal * (item.func_219967_s().func_221469_b() * 2.0f);
            ITextComponent foodTooltip = new TranslationTextComponent("tooltip.jeiintegration.hunger", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + healVal + " ")).func_150257_a((ITextComponent)new TranslationTextComponent("tooltip.jeiintegration.saturation", new Object[0])).func_150257_a((ITextComponent)new StringTextComponent(" " + satVal)).func_211708_a(TextFormatting.DARK_GRAY);
            if (Objects.equals(this.config.foodTooltipMode.get(), "enabled")) {
                e.getToolTip().add(foodTooltip);
            } else if (Objects.equals(this.config.foodTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(foodTooltip);
            } else if (Objects.equals(this.config.foodTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(foodTooltip);
            } else if (Objects.equals(this.config.foodTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(foodTooltip);
            }
        }
        if ((nbtData = item.getShareTag(itemStack)) != null) {
            ITextComponent nbtTooltip = new TranslationTextComponent("tooltip.jeiintegration.nbtTagData", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + nbtData)).func_211708_a(TextFormatting.DARK_GRAY);
            if (Objects.equals(this.config.nbtTooltipMode.get(), "enabled")) {
                e.getToolTip().add(nbtTooltip);
            } else if (Objects.equals(this.config.nbtTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(nbtTooltip);
            } else if (Objects.equals(this.config.nbtTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(nbtTooltip);
            } else if (Objects.equals(this.config.nbtTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(nbtTooltip);
            }
        }
        ITextComponent registryTooltip = new TranslationTextComponent("tooltip.jeiintegration.registryName", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + item.getRegistryName())).func_211708_a(TextFormatting.DARK_GRAY);
        if (Objects.equals(this.config.registryNameTooltipMode.get(), "enabled")) {
            e.getToolTip().add(registryTooltip);
        } else if (Objects.equals(this.config.registryNameTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
            e.getToolTip().add(registryTooltip);
        } else if (Objects.equals(this.config.registryNameTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
            e.getToolTip().add(registryTooltip);
        } else if (Objects.equals(this.config.registryNameTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
            e.getToolTip().add(registryTooltip);
        }
        int stackSize = e.getItemStack().func_77976_d();
        if (stackSize > 0) {
            ITextComponent stackSizeTooltip = new TranslationTextComponent("tooltip.jeiintegration.maxStackSize", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + itemStack.func_77976_d())).func_211708_a(TextFormatting.DARK_GRAY);
            if (Objects.equals(this.config.maxStackSizeTooltipMode.get(), "enabled")) {
                e.getToolTip().add(stackSizeTooltip);
            } else if (Objects.equals(this.config.maxStackSizeTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(stackSizeTooltip);
            } else if (Objects.equals(this.config.maxStackSizeTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(stackSizeTooltip);
            } else if (Objects.equals(this.config.maxStackSizeTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(stackSizeTooltip);
            }
        }
        if (item.getTags().size() > 0) {
            ITextComponent tagsTooltip = new TranslationTextComponent("tooltip.jeiintegration.tags", new Object[0]).func_211708_a(TextFormatting.DARK_GRAY);
            ArrayList<ITextComponent> tags = new ArrayList<ITextComponent>();
            for (ResourceLocation tag : item.getTags()) {
                tags.add(new StringTextComponent("    " + tag).func_211708_a(TextFormatting.DARK_GRAY));
            }
            if (Objects.equals(this.config.tagsTooltipMode.get(), "enabled")) {
                e.getToolTip().add(tagsTooltip);
                e.getToolTip().addAll(tags);
            } else if (Objects.equals(this.config.tagsTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
                e.getToolTip().add(tagsTooltip);
                e.getToolTip().addAll(tags);
            } else if (Objects.equals(this.config.tagsTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(tagsTooltip);
                e.getToolTip().addAll(tags);
            } else if (Objects.equals(this.config.tagsTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
                e.getToolTip().add(tagsTooltip);
                e.getToolTip().addAll(tags);
            }
        }
        ITextComponent translationKeyTooltip = new TranslationTextComponent("tooltip.jeiintegration.translationKey", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + itemStack.func_77977_a())).func_211708_a(TextFormatting.DARK_GRAY);
        if (Objects.equals(this.config.translationKeyTooltipMode.get(), "enabled")) {
            e.getToolTip().add(translationKeyTooltip);
        } else if (Objects.equals(this.config.translationKeyTooltipMode.get(), "onShift") && TooltipEventHandler.isShiftKeyDown()) {
            e.getToolTip().add(translationKeyTooltip);
        } else if (Objects.equals(this.config.translationKeyTooltipMode.get(), "onDebug") && TooltipEventHandler.isDebugMode()) {
            e.getToolTip().add(translationKeyTooltip);
        } else if (Objects.equals(this.config.translationKeyTooltipMode.get(), "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
            e.getToolTip().add(translationKeyTooltip);
        }
    }
}

