/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.RailShape;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import net.minecraft.util.datafix.fixes.ItemStackDataFlattening;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Tools {
    public static BlockState stringToState(String s) {
        if ("minecraft:double_stone_slab".equals(s)) {
            return (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
        }
        String original = s;
        int meta = 0;
        if (s.contains("@")) {
            String[] split = s.split("@");
            meta = Integer.parseInt(split[1]);
            s = split[0];
        }
        if (s.equals("minecraft:stone_brick_stairs")) {
            return Tools.getStairsState(meta, Blocks.field_150390_bg.func_176223_P());
        }
        if (s.equals("minecraft:quartz_stairs")) {
            return Tools.getStairsState(meta, Blocks.field_150370_cb.func_176223_P());
        }
        if (s.equals("minecraft:stone_stairs")) {
            return Tools.getStairsState(meta, Blocks.field_222438_lb.func_176223_P());
        }
        if (s.equals("minecraft:rail")) {
            return Tools.getRailState(meta, Blocks.field_150448_aq.func_176223_P());
        }
        if (s.equals("minecraft:golden_rail")) {
            return Tools.getPoweredRailState(meta, Blocks.field_196552_aC.func_176223_P());
        }
        if (s.equals("minecraft:stone_slab")) {
            return Tools.getStoneSlabState(meta, Blocks.field_222401_hJ.func_176223_P());
        }
        if (s.equals("minecraft:redstone_torch")) {
            return Tools.getRedstoneTorchState(meta);
        }
        if (s.equals("minecraft:ladder")) {
            return Tools.getLadderState(meta);
        }
        String converted = ItemStackDataFlattening.func_199175_a((String)s, (int)meta);
        if (converted != null) {
            s = converted;
        } else {
            converted = BlockStateFlatteningMap.func_199198_a((String)s);
            if (converted != null) {
                s = converted;
            }
        }
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
        if (value == null) {
            throw new RuntimeException("Cannot find block: '" + s + "'!");
        }
        return value.func_176223_P();
    }

    private static BlockState getLadderState(int meta) {
        Direction direction = Direction.values()[MathHelper.func_76130_a((int)(meta % Direction.values().length))];
        if (direction.func_176740_k() == Direction.Axis.Y) {
            direction = Direction.NORTH;
        }
        return (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)direction);
    }

    private static BlockState getRedstoneTorchState(int meta) {
        switch (meta) {
            case 1: {
                return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.EAST);
            }
            case 2: {
                return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.WEST);
            }
            case 3: {
                return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.SOUTH);
            }
            case 4: {
                return (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.NORTH);
            }
            case 5: {
                return Blocks.field_150429_aA.func_176223_P();
            }
        }
        return Blocks.field_150429_aA.func_176223_P();
    }

    private static BlockState getStoneSlabState(int meta, BlockState state) {
        state.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)((meta & 8) > 0 ? SlabType.TOP : SlabType.BOTTOM));
        return state;
    }

    private static BlockState getRailState(int meta, BlockState state) {
        return (BlockState)state.func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)Tools.getRailShape(meta, false));
    }

    private static BlockState getPoweredRailState(int meta, BlockState state) {
        return (BlockState)((BlockState)state.func_206870_a((IProperty)PoweredRailBlock.field_176568_b, (Comparable)Tools.getRailShape(meta, true))).func_206870_a((IProperty)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    private static BlockState getStairsState(int meta, BlockState state) {
        return (BlockState)((BlockState)state.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Tools.getStairsDirection(meta))).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)Tools.getStairsHalf(meta));
    }

    private static Direction getStairsDirection(int meta) {
        int index = 5 - (meta & 3);
        return Direction.values()[MathHelper.func_76130_a((int)(index % Direction.values().length))];
    }

    private static Half getStairsHalf(int meta) {
        return (meta & 4) > 0 ? Half.TOP : Half.BOTTOM;
    }

    private static RailShape getRailShape(int meta, boolean powered) {
        if (powered) {
            meta &= 7;
        }
        switch (meta) {
            case 0: {
                return RailShape.NORTH_SOUTH;
            }
            case 1: {
                return RailShape.EAST_WEST;
            }
            case 2: {
                return RailShape.ASCENDING_EAST;
            }
            case 3: {
                return RailShape.ASCENDING_WEST;
            }
            case 4: {
                return RailShape.ASCENDING_NORTH;
            }
            case 5: {
                return RailShape.ASCENDING_SOUTH;
            }
            case 6: {
                return RailShape.SOUTH_EAST;
            }
            case 7: {
                return RailShape.SOUTH_WEST;
            }
            case 8: {
                return RailShape.NORTH_WEST;
            }
            case 9: {
                return RailShape.NORTH_EAST;
            }
        }
        return RailShape.NORTH_SOUTH;
    }

    public static String stateToString(BlockState state) {
        return state.func_177230_c().getRegistryName().toString();
    }

    public static String getRandomFromList(Random random, List<Pair<Float, String>> list) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<Pair<Float, String>> elements = new ArrayList<Pair<Float, String>>();
        float totalweight = 0.0f;
        for (Pair<Float, String> pair : list) {
            elements.add(pair);
            totalweight += ((Float)pair.getKey()).floatValue();
        }
        float r = random.nextFloat() * totalweight;
        for (Pair pair : elements) {
            if (!((r -= ((Float)pair.getKey()).floatValue()) <= 0.0f)) continue;
            return (String)pair.getRight();
        }
        return null;
    }
}

