/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void render(int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            RenderSystem.enableDepthTest();
            RenderHelper.func_227780_a_();
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            ItemRenderer itemRenderer = minecraft.func_175599_af();
            itemRenderer.func_184391_a(null, ingredient, xPosition, yPosition);
            itemRenderer.func_180453_a(font, ingredient, xPosition, yPosition, null);
            RenderSystem.disableBlend();
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public List<String> getTooltip(ItemStack ingredient, ITooltipFlag tooltipFlag) {
        Rarity rarity;
        List<String> list;
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        try {
            list = ingredient.func_82840_a((PlayerEntity)player, tooltipFlag).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.error.crash"));
            return list2;
        }
        try {
            rarity = ingredient.func_77953_t();
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get rarity: {}", (Object)itemStackInfo, (Object)e);
            rarity = Rarity.COMMON;
        }
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, rarity.field_77937_e + list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + list.get(k));
        }
        return list;
    }

    @Override
    public FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        FontRenderer fontRenderer = ingredient.func_77973_b().getFontRenderer(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }
}

